/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.dmn.impl.instance;

import java.util.Collection;
import org.camunda.bpm.model.dmn.impl.instance.DrgElementImpl;
import org.camunda.bpm.model.dmn.instance.AllowedAnswers;
import org.camunda.bpm.model.dmn.instance.AuthorityRequirement;
import org.camunda.bpm.model.dmn.instance.Decision;
import org.camunda.bpm.model.dmn.instance.DecisionMakerReference;
import org.camunda.bpm.model.dmn.instance.DecisionOwnerReference;
import org.camunda.bpm.model.dmn.instance.DrgElement;
import org.camunda.bpm.model.dmn.instance.Expression;
import org.camunda.bpm.model.dmn.instance.ImpactedPerformanceIndicatorReference;
import org.camunda.bpm.model.dmn.instance.InformationRequirement;
import org.camunda.bpm.model.dmn.instance.KnowledgeRequirement;
import org.camunda.bpm.model.dmn.instance.OrganizationUnit;
import org.camunda.bpm.model.dmn.instance.PerformanceIndicator;
import org.camunda.bpm.model.dmn.instance.Question;
import org.camunda.bpm.model.dmn.instance.SupportedObjectiveReference;
import org.camunda.bpm.model.dmn.instance.UsingProcessReference;
import org.camunda.bpm.model.dmn.instance.UsingTaskReference;
import org.camunda.bpm.model.dmn.instance.Variable;
import org.camunda.bpm.model.xml.ModelBuilder;
import org.camunda.bpm.model.xml.impl.instance.ModelTypeInstanceContext;
import org.camunda.bpm.model.xml.type.ModelElementTypeBuilder;
import org.camunda.bpm.model.xml.type.attribute.Attribute;
import org.camunda.bpm.model.xml.type.child.ChildElement;
import org.camunda.bpm.model.xml.type.child.ChildElementCollection;
import org.camunda.bpm.model.xml.type.child.SequenceBuilder;
import org.camunda.bpm.model.xml.type.reference.ElementReferenceCollection;

public class DecisionImpl
extends DrgElementImpl
implements Decision {
    protected static ChildElement<Question> questionChild;
    protected static ChildElement<AllowedAnswers> allowedAnswersChild;
    protected static ChildElement<Variable> variableChild;
    protected static ChildElementCollection<InformationRequirement> informationRequirementCollection;
    protected static ChildElementCollection<KnowledgeRequirement> knowledgeRequirementCollection;
    protected static ChildElementCollection<AuthorityRequirement> authorityRequirementCollection;
    protected static ChildElementCollection<SupportedObjectiveReference> supportedObjectiveChildElementCollection;
    protected static ElementReferenceCollection<PerformanceIndicator, ImpactedPerformanceIndicatorReference> impactedPerformanceIndicatorRefCollection;
    protected static ElementReferenceCollection<OrganizationUnit, DecisionMakerReference> decisionMakerRefCollection;
    protected static ElementReferenceCollection<OrganizationUnit, DecisionOwnerReference> decisionOwnerRefCollection;
    protected static ChildElementCollection<UsingProcessReference> usingProcessCollection;
    protected static ChildElementCollection<UsingTaskReference> usingTaskCollection;
    protected static ChildElement<Expression> expressionChild;
    protected static Attribute<String> camundaHistoryTimeToLiveAttribute;
    protected static Attribute<String> camundaVersionTag;

    public DecisionImpl(ModelTypeInstanceContext instanceContext) {
        super(instanceContext);
    }

    @Override
    public Question getQuestion() {
        return questionChild.getChild(this);
    }

    @Override
    public void setQuestion(Question question) {
        questionChild.setChild(this, question);
    }

    @Override
    public AllowedAnswers getAllowedAnswers() {
        return allowedAnswersChild.getChild(this);
    }

    @Override
    public void setAllowedAnswers(AllowedAnswers allowedAnswers) {
        allowedAnswersChild.setChild(this, allowedAnswers);
    }

    @Override
    public Variable getVariable() {
        return variableChild.getChild(this);
    }

    @Override
    public void setVariable(Variable variable) {
        variableChild.setChild(this, variable);
    }

    @Override
    public Collection<InformationRequirement> getInformationRequirements() {
        return informationRequirementCollection.get(this);
    }

    @Override
    public Collection<KnowledgeRequirement> getKnowledgeRequirements() {
        return knowledgeRequirementCollection.get(this);
    }

    @Override
    public Collection<AuthorityRequirement> getAuthorityRequirements() {
        return authorityRequirementCollection.get(this);
    }

    @Override
    public Collection<SupportedObjectiveReference> getSupportedObjectiveReferences() {
        return supportedObjectiveChildElementCollection.get(this);
    }

    @Override
    public Collection<PerformanceIndicator> getImpactedPerformanceIndicators() {
        return impactedPerformanceIndicatorRefCollection.getReferenceTargetElements(this);
    }

    @Override
    public Collection<OrganizationUnit> getDecisionMakers() {
        return decisionMakerRefCollection.getReferenceTargetElements(this);
    }

    @Override
    public Collection<OrganizationUnit> getDecisionOwners() {
        return decisionOwnerRefCollection.getReferenceTargetElements(this);
    }

    @Override
    public Collection<UsingProcessReference> getUsingProcessReferences() {
        return usingProcessCollection.get(this);
    }

    @Override
    public Collection<UsingTaskReference> getUsingTaskReferences() {
        return usingTaskCollection.get(this);
    }

    @Override
    public Expression getExpression() {
        return expressionChild.getChild(this);
    }

    @Override
    public void setExpression(Expression expression) {
        expressionChild.setChild(this, expression);
    }

    @Override
    public Integer getCamundaHistoryTimeToLive() {
        String ttl = this.getCamundaHistoryTimeToLiveString();
        if (ttl != null) {
            return Integer.valueOf(ttl);
        }
        return null;
    }

    @Override
    public void setCamundaHistoryTimeToLive(Integer historyTimeToLive) {
        this.setCamundaHistoryTimeToLiveString(String.valueOf(historyTimeToLive));
    }

    @Override
    public String getCamundaHistoryTimeToLiveString() {
        return camundaHistoryTimeToLiveAttribute.getValue(this);
    }

    @Override
    public void setCamundaHistoryTimeToLiveString(String historyTimeToLive) {
        camundaHistoryTimeToLiveAttribute.setValue(this, historyTimeToLive);
    }

    @Override
    public String getVersionTag() {
        return camundaVersionTag.getValue(this);
    }

    @Override
    public void setVersionTag(String inputVariable) {
        camundaVersionTag.setValue(this, inputVariable);
    }

    public static void registerType(ModelBuilder modelBuilder) {
        ModelElementTypeBuilder typeBuilder = modelBuilder.defineType(Decision.class, "decision").namespaceUri("https://www.omg.org/spec/DMN/20191111/MODEL/").extendsType(DrgElement.class).instanceProvider(new ModelElementTypeBuilder.ModelTypeInstanceProvider<Decision>(){

            @Override
            public Decision newInstance(ModelTypeInstanceContext instanceContext) {
                return new DecisionImpl(instanceContext);
            }
        });
        SequenceBuilder sequenceBuilder = typeBuilder.sequence();
        questionChild = sequenceBuilder.element(Question.class).build();
        allowedAnswersChild = sequenceBuilder.element(AllowedAnswers.class).build();
        variableChild = sequenceBuilder.element(Variable.class).build();
        informationRequirementCollection = sequenceBuilder.elementCollection(InformationRequirement.class).build();
        knowledgeRequirementCollection = sequenceBuilder.elementCollection(KnowledgeRequirement.class).build();
        authorityRequirementCollection = sequenceBuilder.elementCollection(AuthorityRequirement.class).build();
        supportedObjectiveChildElementCollection = sequenceBuilder.elementCollection(SupportedObjectiveReference.class).build();
        impactedPerformanceIndicatorRefCollection = sequenceBuilder.elementCollection(ImpactedPerformanceIndicatorReference.class).uriElementReferenceCollection(PerformanceIndicator.class).build();
        decisionMakerRefCollection = sequenceBuilder.elementCollection(DecisionMakerReference.class).uriElementReferenceCollection(OrganizationUnit.class).build();
        decisionOwnerRefCollection = sequenceBuilder.elementCollection(DecisionOwnerReference.class).uriElementReferenceCollection(OrganizationUnit.class).build();
        usingProcessCollection = sequenceBuilder.elementCollection(UsingProcessReference.class).build();
        usingTaskCollection = sequenceBuilder.elementCollection(UsingTaskReference.class).build();
        expressionChild = sequenceBuilder.element(Expression.class).build();
        camundaHistoryTimeToLiveAttribute = typeBuilder.stringAttribute("historyTimeToLive").namespace("http://camunda.org/schema/1.0/dmn").build();
        camundaVersionTag = typeBuilder.stringAttribute("versionTag").namespace("http://camunda.org/schema/1.0/dmn").build();
        typeBuilder.build();
    }
}

