/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.condition;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.IncludeExcludeEndpointFilter;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.ExposableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.EndpointExtension;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.MethodMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ConcurrentReferenceHashMap;

class OnAvailableEndpointCondition
extends SpringBootCondition {
    private static final String JMX_ENABLED_KEY = "spring.jmx.enabled";
    private static final String ENABLED_BY_DEFAULT_KEY = "management.endpoints.enabled-by-default";
    private static final Map<Environment, Set<ExposureFilter>> exposureFiltersCache = new ConcurrentReferenceHashMap<Environment, Set<ExposureFilter>>();
    private static final ConcurrentReferenceHashMap<Environment, Optional<Boolean>> enabledByDefaultCache = new ConcurrentReferenceHashMap();

    OnAvailableEndpointCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Environment environment2 = context.getEnvironment();
        MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation = metadata.getAnnotations().get(ConditionalOnAvailableEndpoint.class);
        Class<?> target = this.getTarget(context, metadata, conditionAnnotation);
        MergedAnnotation<Endpoint> endpointAnnotation = this.getEndpointAnnotation(target);
        return this.getMatchOutcome(environment2, conditionAnnotation, endpointAnnotation);
    }

    private Class<?> getTarget(ConditionContext context, AnnotatedTypeMetadata metadata, MergedAnnotation<ConditionalOnAvailableEndpoint> condition) {
        Class<?> target = condition.getClass("endpoint");
        if (target != Void.class) {
            return target;
        }
        Assert.state(metadata instanceof MethodMetadata && metadata.isAnnotated(Bean.class.getName()), "EndpointCondition must be used on @Bean methods when the endpoint is not specified");
        MethodMetadata methodMetadata = (MethodMetadata)metadata;
        try {
            return ClassUtils.forName(methodMetadata.getReturnTypeName(), context.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to extract endpoint id for " + methodMetadata.getDeclaringClassName() + "." + methodMetadata.getMethodName(), ex);
        }
    }

    protected MergedAnnotation<Endpoint> getEndpointAnnotation(Class<?> target) {
        MergedAnnotations annotations = MergedAnnotations.from(target, MergedAnnotations.SearchStrategy.TYPE_HIERARCHY);
        MergedAnnotation<Endpoint> endpoint = annotations.get(Endpoint.class);
        if (endpoint.isPresent()) {
            return endpoint;
        }
        MergedAnnotation<EndpointExtension> extension = annotations.get(EndpointExtension.class);
        Assert.state(extension.isPresent(), "No endpoint is specified and the return type of the @Bean method is neither an @Endpoint, nor an @EndpointExtension");
        return this.getEndpointAnnotation(extension.getClass("endpoint"));
    }

    private ConditionOutcome getMatchOutcome(Environment environment2, MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation, MergedAnnotation<Endpoint> endpointAnnotation) {
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnAvailableEndpoint.class, new Object[0]);
        EndpointId endpointId = EndpointId.of(environment2, endpointAnnotation.getString("id"));
        ConditionOutcome enablementOutcome = this.getEnablementOutcome(environment2, endpointAnnotation, endpointId, message);
        if (!enablementOutcome.isMatch()) {
            return enablementOutcome;
        }
        Set<EndpointExposure> exposuresToCheck = this.getExposuresToCheck(conditionAnnotation);
        Set<ExposureFilter> exposureFilters = this.getExposureFilters(environment2);
        for (ExposureFilter exposureFilter : exposureFilters) {
            if (!exposuresToCheck.contains((Object)exposureFilter.getExposure()) || !exposureFilter.isExposed(endpointId)) continue;
            return ConditionOutcome.match(message.because("marked as exposed by a 'management.endpoints." + exposureFilter.getExposure().name().toLowerCase() + ".exposure' property"));
        }
        return ConditionOutcome.noMatch(message.because("no 'management.endpoints' property marked it as exposed"));
    }

    private ConditionOutcome getEnablementOutcome(Environment environment2, MergedAnnotation<Endpoint> endpointAnnotation, EndpointId endpointId, ConditionMessage.Builder message) {
        String key = "management.endpoint." + endpointId.toLowerCaseString() + ".enabled";
        Boolean userDefinedEnabled = environment2.getProperty(key, Boolean.class);
        if (userDefinedEnabled != null) {
            return new ConditionOutcome((boolean)userDefinedEnabled, message.because("found property " + key + " with value " + userDefinedEnabled));
        }
        Boolean userDefinedDefault = this.isEnabledByDefault(environment2);
        if (userDefinedDefault != null) {
            return new ConditionOutcome((boolean)userDefinedDefault, message.because("no property " + key + " found so using user defined default from " + ENABLED_BY_DEFAULT_KEY));
        }
        boolean endpointDefault = endpointAnnotation.getBoolean("enableByDefault");
        return new ConditionOutcome(endpointDefault, message.because("no property " + key + " found so using endpoint default of " + endpointDefault));
    }

    private Boolean isEnabledByDefault(Environment environment2) {
        Optional<Boolean> enabledByDefault = enabledByDefaultCache.get(environment2);
        if (enabledByDefault == null) {
            enabledByDefault = Optional.ofNullable(environment2.getProperty(ENABLED_BY_DEFAULT_KEY, Boolean.class));
            enabledByDefaultCache.put(environment2, enabledByDefault);
        }
        return enabledByDefault.orElse(null);
    }

    private Set<EndpointExposure> getExposuresToCheck(MergedAnnotation<ConditionalOnAvailableEndpoint> conditionAnnotation) {
        EndpointExposure[] exposure = (EndpointExposure[])conditionAnnotation.getEnumArray("exposure", EndpointExposure.class);
        return exposure.length == 0 ? EnumSet.allOf(EndpointExposure.class) : new LinkedHashSet<EndpointExposure>(Arrays.asList(exposure));
    }

    private Set<ExposureFilter> getExposureFilters(Environment environment2) {
        Set<ExposureFilter> exposureFilters = exposureFiltersCache.get(environment2);
        if (exposureFilters == null) {
            exposureFilters = new HashSet<ExposureFilter>(2);
            if (environment2.getProperty(JMX_ENABLED_KEY, Boolean.class, false).booleanValue()) {
                exposureFilters.add(new ExposureFilter(environment2, EndpointExposure.JMX));
            }
            if (CloudPlatform.CLOUD_FOUNDRY.isActive(environment2)) {
                exposureFilters.add(new ExposureFilter(environment2, EndpointExposure.CLOUD_FOUNDRY));
            }
            exposureFilters.add(new ExposureFilter(environment2, EndpointExposure.WEB));
            exposureFiltersCache.put(environment2, exposureFilters);
        }
        return exposureFilters;
    }

    static final class ExposureFilter
    extends IncludeExcludeEndpointFilter<ExposableEndpoint<?>> {
        private final EndpointExposure exposure;

        private ExposureFilter(Environment environment2, EndpointExposure exposure) {
            super(ExposableEndpoint.class, environment2, "management.endpoints." + ExposureFilter.getCanonicalName(exposure) + ".exposure", exposure.getDefaultIncludes());
            this.exposure = exposure;
        }

        private static String getCanonicalName(EndpointExposure exposure) {
            if (EndpointExposure.CLOUD_FOUNDRY.equals((Object)exposure)) {
                return "cloud-foundry";
            }
            return exposure.name().toLowerCase();
        }

        EndpointExposure getExposure() {
            return this.exposure;
        }

        boolean isExposed(EndpointId id) {
            return super.match(id);
        }
    }
}

