/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.util.Collection;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.endpoint.expose.EndpointExposure;
import org.springframework.boot.actuate.autoconfigure.health.HealthEndpointProperties;
import org.springframework.boot.actuate.endpoint.web.EndpointMapping;
import org.springframework.boot.actuate.endpoint.web.ExposableWebEndpoint;
import org.springframework.boot.actuate.endpoint.web.WebEndpointsSupplier;
import org.springframework.boot.actuate.endpoint.web.WebServerNamespace;
import org.springframework.boot.actuate.endpoint.web.reactive.AdditionalHealthEndpointPathsWebFluxHandlerMapping;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.health.HealthEndpointGroups;
import org.springframework.boot.actuate.health.ReactiveHealthContributorRegistry;
import org.springframework.boot.actuate.health.ReactiveHealthEndpointWebExtension;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB, EndpointExposure.CLOUD_FOUNDRY})
class HealthEndpointReactiveWebExtensionConfiguration {
    HealthEndpointReactiveWebExtensionConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={HealthEndpoint.class})
    ReactiveHealthEndpointWebExtension reactiveHealthEndpointWebExtension(ReactiveHealthContributorRegistry reactiveHealthContributorRegistry, HealthEndpointGroups groups, HealthEndpointProperties properties) {
        return new ReactiveHealthEndpointWebExtension(reactiveHealthContributorRegistry, groups, properties.getLogging().getSlowIndicatorThreshold());
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnAvailableEndpoint(endpoint=HealthEndpoint.class, exposure={EndpointExposure.WEB})
    static class WebFluxAdditionalHealthEndpointPathsConfiguration {
        WebFluxAdditionalHealthEndpointPathsConfiguration() {
        }

        @Bean
        AdditionalHealthEndpointPathsWebFluxHandlerMapping healthEndpointWebFluxHandlerMapping(WebEndpointsSupplier webEndpointsSupplier, HealthEndpointGroups groups) {
            Collection webEndpoints = webEndpointsSupplier.getEndpoints();
            ExposableWebEndpoint health = webEndpoints.stream().filter(endpoint -> endpoint.getEndpointId().equals(HealthEndpoint.ID)).findFirst().get();
            return new AdditionalHealthEndpointPathsWebFluxHandlerMapping(new EndpointMapping(""), health, groups.getAllWithAdditionalPath(WebServerNamespace.SERVER));
        }
    }
}

