/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.r2dbc;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.r2dbc.pool.ConnectionPool;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Wrapped;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.metrics.r2dbc.ConnectionPoolMetrics;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcAutoConfiguration;

@AutoConfiguration(after={MetricsAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class, R2dbcAutoConfiguration.class})
@ConditionalOnClass(value={ConnectionPool.class, MeterRegistry.class})
@ConditionalOnBean(value={ConnectionFactory.class, MeterRegistry.class})
public class ConnectionPoolMetricsAutoConfiguration {
    @Autowired
    public void bindConnectionPoolsToRegistry(Map<String, ConnectionFactory> connectionFactories, MeterRegistry registry) {
        connectionFactories.forEach((beanName, connectionFactory) -> {
            ConnectionPool pool = this.extractPool(connectionFactory);
            if (pool != null) {
                new ConnectionPoolMetrics(pool, (String)beanName, (Iterable<Tag>)Tags.empty()).bindTo(registry);
            }
        });
    }

    private ConnectionPool extractPool(Object candidate) {
        if (candidate instanceof ConnectionPool) {
            return (ConnectionPool)candidate;
        }
        if (candidate instanceof Wrapped) {
            return this.extractPool(((Wrapped)candidate).unwrap());
        }
        return null;
    }
}

