/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.jersey;

import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextType;
import org.springframework.boot.actuate.autoconfigure.web.jersey.JerseyManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.jersey.ManagementContextResourceConfigCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.jersey.JerseyProperties;
import org.springframework.boot.autoconfigure.jersey.ResourceConfigCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.DefaultJerseyApplicationPath;
import org.springframework.boot.autoconfigure.web.servlet.JerseyApplicationPath;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ManagementContextConfiguration(value=ManagementContextType.SAME, proxyBeanMethods=false)
@EnableConfigurationProperties(value={JerseyProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={ResourceConfig.class})
@ConditionalOnMissingClass(value={"org.springframework.web.servlet.DispatcherServlet"})
public class JerseySameManagementContextConfiguration {
    @Bean
    ResourceConfigCustomizer managementResourceConfigCustomizerAdapter(ObjectProvider<ManagementContextResourceConfigCustomizer> customizers) {
        return config -> customizers.orderedStream().forEach(customizer2 -> customizer2.customize(config));
    }

    @Configuration(proxyBeanMethods=false)
    @Import(value={JerseyManagementContextConfiguration.class})
    @ConditionalOnMissingBean(value={ResourceConfig.class})
    static class JerseyInfrastructureConfiguration {
        JerseyInfrastructureConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={JerseyApplicationPath.class})
        JerseyApplicationPath jerseyApplicationPath(JerseyProperties properties, ResourceConfig config) {
            return new DefaultJerseyApplicationPath(properties.getApplicationPath(), config);
        }

        @Bean
        ResourceConfig resourceConfig(ObjectProvider<ResourceConfigCustomizer> resourceConfigCustomizers) {
            ResourceConfig resourceConfig = new ResourceConfig();
            resourceConfigCustomizers.orderedStream().forEach(customizer2 -> customizer2.customize(resourceConfig));
            return resourceConfig;
        }
    }
}

