/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import com.google.protobuf.ByteString;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.ClientException;
import io.camunda.zeebe.client.api.command.DeployResourceCommandStep1;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.response.DeploymentEvent;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.command.StreamUtil;
import io.camunda.zeebe.client.impl.response.DeploymentEventImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.grpc.stub.StreamObserver;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class DeployResourceCommandImpl
implements DeployResourceCommandStep1,
DeployResourceCommandStep1.DeployResourceCommandStep2 {
    private final GatewayOuterClass.DeployResourceRequest.Builder requestBuilder = GatewayOuterClass.DeployResourceRequest.newBuilder();
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<Throwable> retryPredicate;
    private Duration requestTimeout;

    public DeployResourceCommandImpl(GatewayGrpc.GatewayStub asyncStub, ZeebeClientConfiguration config, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = config.getDefaultRequestTimeout();
        this.retryPredicate = retryPredicate;
        this.tenantId(config.getDefaultTenantId());
    }

    @Deprecated
    public DeployResourceCommandImpl(GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
        this.tenantId("<default>");
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceBytes(byte[] resource, String resourceName) {
        this.requestBuilder.addResources(GatewayOuterClass.Resource.newBuilder().setName(resourceName).setContent(ByteString.copyFrom(resource)).build());
        return this;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceString(String resource, Charset charset, String resourceName) {
        return this.addResourceBytes(resource.getBytes(charset), resourceName);
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceStringUtf8(String resourceString, String resourceName) {
        return this.addResourceString(resourceString, StandardCharsets.UTF_8, resourceName);
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceStream(InputStream resourceStream, String resourceName) {
        ArgumentUtil.ensureNotNull("resource stream", resourceStream);
        try {
            byte[] bytes = StreamUtil.readInputStream(resourceStream);
            return this.addResourceBytes(bytes, resourceName);
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy bpmn resource from stream. %s", e.getMessage());
            throw new ClientException(exceptionMsg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceFromClasspath(String classpathResource) {
        ArgumentUtil.ensureNotNull("classpath resource", classpathResource);
        try (InputStream resourceStream = this.getClass().getClassLoader().getResourceAsStream(classpathResource);){
            if (resourceStream == null) throw new FileNotFoundException(classpathResource);
            DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2 = this.addResourceStream(resourceStream, classpathResource);
            return deployResourceCommandStep2;
        }
        catch (IOException e) {
            String exceptionMsg = String.format("Cannot deploy resource from classpath. %s", e.getMessage());
            throw new RuntimeException(exceptionMsg, e);
        }
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addResourceFile(String filename) {
        DeployResourceCommandStep1.DeployResourceCommandStep2 deployResourceCommandStep2;
        ArgumentUtil.ensureNotNull("filename", filename);
        FileInputStream resourceStream = new FileInputStream(filename);
        try {
            deployResourceCommandStep2 = this.addResourceStream(resourceStream, filename);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)resourceStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String exceptionMsg = String.format("Cannot deploy resource from file. %s", e.getMessage());
                throw new RuntimeException(exceptionMsg, e);
            }
        }
        ((InputStream)resourceStream).close();
        return deployResourceCommandStep2;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 addProcessModel(BpmnModelInstance processDefinition, String resourceName) {
        ArgumentUtil.ensureNotNull("process model", processDefinition);
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Bpmn.writeModelToStream(outStream, processDefinition);
        return this.addResourceBytes(outStream.toByteArray(), resourceName);
    }

    @Override
    public FinalCommandStep<DeploymentEvent> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<DeploymentEvent> send() {
        GatewayOuterClass.DeployResourceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployResourceResponse> future = new RetriableClientFutureImpl<DeploymentEvent, GatewayOuterClass.DeployResourceResponse>(DeploymentEventImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver)streamObserver));
        this.send(request, future);
        return future;
    }

    @Override
    public DeployResourceCommandStep1.DeployResourceCommandStep2 tenantId(String tenantId) {
        this.requestBuilder.setTenantId(tenantId);
        return this;
    }

    private void send(GatewayOuterClass.DeployResourceRequest request, StreamObserver streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).deployResource(request, streamObserver);
    }
}

