/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.command;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.ZeebeFuture;
import io.camunda.zeebe.client.api.command.FinalCommandStep;
import io.camunda.zeebe.client.api.command.ModifyProcessInstanceCommandStep1;
import io.camunda.zeebe.client.api.response.ModifyProcessInstanceResponse;
import io.camunda.zeebe.client.impl.RetriableClientFutureImpl;
import io.camunda.zeebe.client.impl.command.ArgumentUtil;
import io.camunda.zeebe.client.impl.response.ModifyProcessInstanceResponseImpl;
import io.camunda.zeebe.gateway.protocol.GatewayGrpc;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import io.grpc.stub.StreamObserver;
import java.io.InputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class ModifyProcessInstanceCommandImpl
implements ModifyProcessInstanceCommandStep1,
ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 {
    private static final String EMPTY_SCOPE_ID = "";
    private static final long EMPTY_ANCESTOR_KEY = -1L;
    private final GatewayOuterClass.ModifyProcessInstanceRequest.Builder requestBuilder = GatewayOuterClass.ModifyProcessInstanceRequest.newBuilder();
    private final JsonMapper jsonMapper;
    private final GatewayGrpc.GatewayStub asyncStub;
    private final Predicate<Throwable> retryPredicate;
    private GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction latestActivateInstruction;
    private Duration requestTimeout;

    public ModifyProcessInstanceCommandImpl(long processInstanceKey, JsonMapper jsonMapper, GatewayGrpc.GatewayStub asyncStub, Duration requestTimeout, Predicate<Throwable> retryPredicate) {
        this.requestBuilder.setProcessInstanceKey(processInstanceKey);
        this.jsonMapper = jsonMapper;
        this.asyncStub = asyncStub;
        this.requestTimeout = requestTimeout;
        this.retryPredicate = retryPredicate;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 activateElement(String elementId) {
        return this.activateElement(elementId, -1L);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 activateElement(String elementId, long ancestorElementInstanceKey) {
        return this.addActivateInstruction(elementId, ancestorElementInstanceKey);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep2 terminateElement(long elementInstanceKey) {
        this.requestBuilder.addTerminateInstructions(GatewayOuterClass.ModifyProcessInstanceRequest.TerminateInstruction.newBuilder().setElementInstanceKey(elementInstanceKey).build());
        return this;
    }

    private ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 addActivateInstruction(String elementId, long ancestorElementInstanceKey) {
        GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction activateInstruction;
        this.latestActivateInstruction = activateInstruction = GatewayOuterClass.ModifyProcessInstanceRequest.ActivateInstruction.newBuilder().setElementId(elementId).setAncestorElementInstanceKey(ancestorElementInstanceKey).build();
        this.requestBuilder.addActivateInstructions(activateInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1 and() {
        this.latestActivateInstruction = null;
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(InputStream variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(InputStream variables, String scopeId) {
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(String variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(String variables, String scopeId) {
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Map<String, Object> variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Map<String, Object> variables, String scopeId) {
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Object variables) {
        return this.withVariables(variables, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariables(Object variables, String scopeId) {
        GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction = this.createVariableInstruction(variables, scopeId);
        this.addVariableInstructionToLatestActivateInstruction(variableInstruction);
        return this;
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariable(String key, Object value) {
        return this.withVariable(key, value, EMPTY_SCOPE_ID);
    }

    @Override
    public ModifyProcessInstanceCommandStep1.ModifyProcessInstanceCommandStep3 withVariable(String key, Object value, String scopeId) {
        ArgumentUtil.ensureNotNull("key", key);
        return this.withVariables(Collections.singletonMap(key, value), scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(InputStream variables, String scopeId) {
        ArgumentUtil.ensureNotNull("variables", variables);
        String variablesString = this.jsonMapper.validateJson("variables", variables);
        return this.createVariableInstruction(variablesString, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(Map<String, Object> variables, String scopeId) {
        return this.createVariableInstruction((Object)variables, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(Object variables, String scopeId) {
        ArgumentUtil.ensureNotNull("variables", variables);
        String variablesString = this.jsonMapper.toJson(variables);
        return this.createVariableInstruction(variablesString, scopeId);
    }

    private GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction createVariableInstruction(String variables, String scopeId) {
        return GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction.newBuilder().setVariables(this.jsonMapper.validateJson("variables", variables)).setScopeId(scopeId).build();
    }

    private void addVariableInstructionToLatestActivateInstruction(GatewayOuterClass.ModifyProcessInstanceRequest.VariableInstruction variableInstruction) {
        this.requestBuilder.removeActivateInstructions(this.requestBuilder.getActivateInstructionsList().indexOf(this.latestActivateInstruction));
        this.latestActivateInstruction = this.latestActivateInstruction.toBuilder().addVariableInstructions(variableInstruction).build();
        this.requestBuilder.addActivateInstructions(this.latestActivateInstruction);
    }

    @Override
    public FinalCommandStep<ModifyProcessInstanceResponse> requestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @Override
    public ZeebeFuture<ModifyProcessInstanceResponse> send() {
        GatewayOuterClass.ModifyProcessInstanceRequest request = this.requestBuilder.build();
        RetriableClientFutureImpl<ModifyProcessInstanceResponse, GatewayOuterClass.ModifyProcessInstanceResponse> future = new RetriableClientFutureImpl<ModifyProcessInstanceResponse, GatewayOuterClass.ModifyProcessInstanceResponse>(ModifyProcessInstanceResponseImpl::new, this.retryPredicate, streamObserver -> this.send(request, (StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse>)streamObserver));
        this.send(request, future);
        return future;
    }

    private void send(GatewayOuterClass.ModifyProcessInstanceRequest request, StreamObserver<GatewayOuterClass.ModifyProcessInstanceResponse> streamObserver) {
        ((GatewayGrpc.GatewayStub)this.asyncStub.withDeadlineAfter(this.requestTimeout.toMillis(), TimeUnit.MILLISECONDS)).modifyProcessInstance(request, streamObserver);
    }
}

