/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.util;

import java.util.HashMap;
import java.util.Map;

public final class Environment {
    private final Map<String, String> variables;

    private Environment(Map<String, String> variables) {
        this.variables = new HashMap<String, String>(variables);
    }

    public static Environment system() {
        return EnvironmentSingleton.SYSTEM;
    }

    public String get(String key) {
        return this.variables.getOrDefault(key, System.getenv(key));
    }

    public void put(String key, String value) {
        this.variables.put(key, value);
    }

    public String remove(String key) {
        return this.variables.remove(key);
    }

    public boolean isDefined(String key) {
        return this.get(key) != null;
    }

    public boolean getBoolean(String key) {
        return this.isDefined(key) && this.get(key).equals("true");
    }

    Map<String, String> copy() {
        return new HashMap<String, String>(this.variables);
    }

    void overwrite(Map<String, String> environment2) {
        this.variables.clear();
        this.variables.putAll(environment2);
    }

    private static final class EnvironmentSingleton {
        private static final Environment SYSTEM = new Environment(System.getenv());

        private EnvironmentSingleton() {
        }
    }
}

