/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb.transaction;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.EnumSet;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksObject;
import org.rocksdb.Status;
import org.rocksdb.Transaction;

public final class RocksDbInternal {
    static final EnumSet<Status.Code> RECOVERABLE_ERROR_CODES = EnumSet.of(Status.Code.Ok, new Status.Code[]{Status.Code.Aborted, Status.Code.Expired, Status.Code.IOError, Status.Code.Busy, Status.Code.TimedOut, Status.Code.TryAgain, Status.Code.MergeInProgress});
    static Field nativeHandle;
    static MethodHandle putWithHandle;
    static MethodHandle getWithHandle;
    static MethodHandle removeWithHandle;

    private static void resolveInternalMethods() throws NoSuchFieldException, NoSuchMethodException {
        RocksDbInternal.nativeHandles();
        RocksDbInternal.putWithHandle();
        RocksDbInternal.getWithHandle();
        RocksDbInternal.removeWithHandle();
    }

    private static void nativeHandles() throws NoSuchFieldException {
        nativeHandle = RocksObject.class.getDeclaredField("nativeHandle_");
        nativeHandle.setAccessible(true);
    }

    private static void putWithHandle() throws NoSuchMethodException {
        Method method = Transaction.class.getDeclaredMethod("put", Long.TYPE, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        method.setAccessible(true);
        try {
            putWithHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void getWithHandle() throws NoSuchMethodException {
        Method method = Transaction.class.getDeclaredMethod("get", Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Long.TYPE);
        method.setAccessible(true);
        try {
            getWithHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void removeWithHandle() throws NoSuchMethodException {
        Method method = Transaction.class.getDeclaredMethod("delete", Long.TYPE, byte[].class, Integer.TYPE, Long.TYPE, Boolean.TYPE);
        method.setAccessible(true);
        try {
            removeWithHandle = MethodHandles.lookup().unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isRocksDbExceptionRecoverable(RocksDBException rdbex) {
        Status status = rdbex.getStatus();
        return RECOVERABLE_ERROR_CODES.contains((Object)status.getCode());
    }

    static {
        RocksDB.loadLibrary();
        try {
            RocksDbInternal.resolveInternalMethods();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

