/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.el.impl;

import io.camunda.zeebe.el.EvaluationContext;
import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.EvaluationWarning;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.impl.EvaluationFailure;
import io.camunda.zeebe.el.impl.FeelEvaluationWarning;
import io.camunda.zeebe.el.impl.FeelExpression;
import io.camunda.zeebe.el.impl.InvalidExpression;
import io.camunda.zeebe.el.impl.StaticExpression;
import io.camunda.zeebe.el.impl.feel.FeelEvaluationResult;
import io.camunda.zeebe.el.impl.feel.FeelVariableContext;
import io.camunda.zeebe.feel.impl.FeelFunctionProvider;
import io.camunda.zeebe.feel.impl.FeelToMessagePackTransformer;
import io.camunda.zeebe.feel.impl.MessagePackValueMapper;
import io.camunda.zeebe.util.EnsureUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.camunda.feel.FeelEngine;
import org.camunda.feel.FeelEngineClock;
import org.camunda.feel.syntaxtree.ParsedExpression;
import org.camunda.feel.syntaxtree.Val;
import scala.util.Either;

public final class FeelExpressionLanguage
implements ExpressionLanguage {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\=(.+)", 32);
    private final FeelToMessagePackTransformer messagePackTransformer = new FeelToMessagePackTransformer();
    private final FeelEngine feelEngine;

    public FeelExpressionLanguage(FeelEngineClock clock) {
        this.feelEngine = new FeelEngine.Builder().customValueMapper(new MessagePackValueMapper()).functionProvider(new FeelFunctionProvider()).clock(clock).build();
    }

    @Override
    public Expression parseExpression(String expression) {
        EnsureUtil.ensureNotNull("expression", expression);
        Matcher expressionMatcher = EXPRESSION_PATTERN.matcher(expression);
        if (expressionMatcher.matches()) {
            String unpackedExpression = expressionMatcher.group(1);
            return this.parseFeelExpression(unpackedExpression);
        }
        return new StaticExpression(expression);
    }

    @Override
    public EvaluationResult evaluateExpression(Expression expression, EvaluationContext context) {
        EnsureUtil.ensureNotNull("expression", expression);
        EnsureUtil.ensureNotNull("context", context);
        if (!expression.isValid()) {
            String failureMessage = expression.getFailureMessage();
            return new EvaluationFailure(expression, failureMessage);
        }
        if (expression instanceof StaticExpression) {
            StaticExpression staticExpression = (StaticExpression)expression;
            return staticExpression;
        }
        if (expression instanceof FeelExpression) {
            FeelExpression feelExpression = (FeelExpression)expression;
            return this.evaluateFeelExpression(expression, context, feelExpression);
        }
        throw new IllegalArgumentException(String.format("Expected FEEL expression or static value but found '%s'", expression));
    }

    private Expression parseFeelExpression(String expression) {
        Either<FeelEngine.Failure, ParsedExpression> parseResult = this.feelEngine.parseExpression(expression);
        if (parseResult.isLeft()) {
            FeelEngine.Failure failure = parseResult.left().get();
            return new InvalidExpression(expression, failure.message());
        }
        ParsedExpression parsedExpression = parseResult.right().get();
        return new FeelExpression(parsedExpression);
    }

    private EvaluationResult evaluateFeelExpression(Expression expression, EvaluationContext context, FeelExpression feelExpression) {
        ParsedExpression parsedExpression = feelExpression.getParsedExpression();
        FeelVariableContext feelContext = new FeelVariableContext(context);
        org.camunda.feel.api.EvaluationResult evaluationResult = this.feelEngine.evaluate(parsedExpression, feelContext);
        List<EvaluationWarning> evaluationWarnings = this.extractEvaluationWarning(evaluationResult);
        if (evaluationResult.isFailure()) {
            String failureMessage = evaluationResult.failure().message();
            return new EvaluationFailure(expression, failureMessage, evaluationWarnings);
        }
        Object result = evaluationResult.result();
        if (result instanceof Val) {
            return new FeelEvaluationResult(expression, (Val)result, evaluationWarnings, this.messagePackTransformer::toMessagePack);
        }
        throw new IllegalStateException(String.format("Expected FEEL evaluation result to be of type '%s' but was '%s'", Val.class, result.getClass()));
    }

    private List<EvaluationWarning> extractEvaluationWarning(org.camunda.feel.api.EvaluationResult evaluationResult) {
        ArrayList<EvaluationWarning> warnings = new ArrayList<EvaluationWarning>();
        evaluationResult.suppressedFailures().foreach(suppressedFailure -> {
            FeelEvaluationWarning warning = new FeelEvaluationWarning(suppressedFailure.failureType().toString(), suppressedFailure.failureMessage());
            return warnings.add(warning);
        });
        return warnings;
    }
}

