/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.behavior;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.VariableState;
import io.camunda.zeebe.msgpack.value.DocumentValue;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;

public final class BpmnSignalBehavior {
    private final SignalRecord signalRecord = new SignalRecord().setVariables(DocumentValue.EMPTY_DOCUMENT);
    private final KeyGenerator keyGenerator;
    private final VariableState variableState;
    private final TypedCommandWriter commandWriter;
    private final ExpressionProcessor expressionBehavior;

    public BpmnSignalBehavior(KeyGenerator keyGenerator, VariableState variableState, Writers writers, ExpressionProcessor expressionBehavior) {
        this.keyGenerator = keyGenerator;
        this.expressionBehavior = expressionBehavior;
        this.variableState = variableState;
        this.commandWriter = writers.command();
    }

    public Either<Failure, ?> broadcastNewSignal(BpmnElementContext context, ExecutableSignal signal) {
        DirectBuffer variables = this.variableState.getVariablesLocalAsDocument(context.getElementInstanceKey());
        return this.evaluateSignalName(signal, context).map(signalName -> {
            this.triggerSignalBroadcast((String)signalName, variables);
            return null;
        });
    }

    private Either<Failure, String> evaluateSignalName(ExecutableSignal signal, BpmnElementContext context) {
        EnsureUtil.ensureNotNull("signal", signal);
        if (signal.getSignalName().isEmpty()) {
            return this.expressionBehavior.evaluateStringExpression(signal.getSignalNameExpression(), context.getElementInstanceKey());
        }
        return Either.right(signal.getSignalName().get());
    }

    private void triggerSignalBroadcast(String signalName, DirectBuffer variables) {
        EnsureUtil.ensureNotNullOrEmpty("signalName", signalName);
        this.signalRecord.reset();
        this.signalRecord.setSignalName(signalName);
        this.signalRecord.setVariables(variables);
        long key = this.keyGenerator.nextKey();
        this.commandWriter.appendFollowUpCommand(key, SignalIntent.BROADCAST, this.signalRecord);
    }
}

