/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableJobWorkerTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;

public final class JobWorkerTaskProcessor
implements BpmnElementProcessor<ExecutableJobWorkerTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnJobBehavior jobBehavior;
    private final BpmnStateBehavior stateBehavior;

    public JobWorkerTaskProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
        this.jobBehavior = behaviors.jobBehavior();
        this.stateBehavior = behaviors.stateBehavior();
    }

    @Override
    public Class<ExecutableJobWorkerTask> getType() {
        return ExecutableJobWorkerTask.class;
    }

    @Override
    public void onActivate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.jobBehavior.evaluateJobExpressions(element, context)).flatMap(j -> this.eventSubscriptionBehavior.subscribeToEvents(element, context).map(ok -> j)).ifRightOrLeft(jobProperties -> {
            this.jobBehavior.createNewJob(context, element, (BpmnJobBehavior.JobProperties)jobProperties);
            this.stateTransitionBehavior.transitionToActivated(context);
        }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onComplete(ExecutableJobWorkerTask element, BpmnElementContext context) {
        this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
    }

    @Override
    public void onTerminate(ExecutableJobWorkerTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.jobBehavior.cancelJob(context);
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)eventTrigger, terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

