/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskProcessor;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableScriptTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;

public final class ScriptTaskProcessor
implements BpmnElementProcessor<ExecutableScriptTask> {
    private final ScriptTaskBehavior zeebeScriptBehavior;
    private final ScriptTaskBehavior jobWorkerTaskBehavior;

    public ScriptTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.zeebeScriptBehavior = new ZeebeScriptBehavior(bpmnBehaviors, stateTransitionBehavior);
        this.jobWorkerTaskBehavior = new JobWorkerTaskBehavior(bpmnBehaviors, stateTransitionBehavior);
    }

    @Override
    public Class<ExecutableScriptTask> getType() {
        return ExecutableScriptTask.class;
    }

    @Override
    public void onActivate(ExecutableScriptTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onActivate(element, context);
    }

    @Override
    public void onComplete(ExecutableScriptTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onComplete(element, context);
    }

    @Override
    public void onTerminate(ExecutableScriptTask element, BpmnElementContext context) {
        this.eventBehaviorOf(element, context).onTerminate(element, context);
    }

    private ScriptTaskBehavior eventBehaviorOf(ExecutableScriptTask element, BpmnElementContext context) {
        if (element.getExpression() != null) {
            return this.zeebeScriptBehavior;
        }
        if (element.getJobWorkerProperties() != null) {
            return this.jobWorkerTaskBehavior;
        }
        throw new BpmnProcessingException(context, "Expected to process script task, but could not determine processing behavior");
    }

    private static final class ZeebeScriptBehavior
    implements ScriptTaskBehavior {
        private final BpmnIncidentBehavior incidentBehavior;
        private final BpmnStateTransitionBehavior stateTransitionBehavior;
        private final BpmnVariableMappingBehavior variableMappingBehavior;
        private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
        private final BpmnStateBehavior stateBehavior;
        private final ExpressionProcessor expressionProcessor;
        private final EventTriggerBehavior eventTriggerBehavior;

        public ZeebeScriptBehavior(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
            this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
            this.incidentBehavior = bpmnBehaviors.incidentBehavior();
            this.stateTransitionBehavior = stateTransitionBehavior;
            this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
            this.stateBehavior = bpmnBehaviors.stateBehavior();
            this.expressionProcessor = bpmnBehaviors.expressionBehavior();
            this.eventTriggerBehavior = bpmnBehaviors.eventTriggerBehavior();
        }

        @Override
        public void onActivate(ExecutableScriptTask element, BpmnElementContext context) {
            this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.evaluateScript(element, context)).ifRightOrLeft(ok -> {
                BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context);
                this.stateTransitionBehavior.completeElement(activated);
            }, failure -> this.incidentBehavior.createIncident((Failure)failure, context));
        }

        @Override
        public void onComplete(ExecutableScriptTask element, BpmnElementContext context) {
            this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).ifRightOrLeft(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed), failure -> this.incidentBehavior.createIncident((Failure)failure, context));
        }

        @Override
        public void onTerminate(ExecutableScriptTask element, BpmnElementContext context) {
            ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
            this.incidentBehavior.resolveIncidents(context);
            this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).ifPresentOrElse(eventTrigger -> {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
                this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)eventTrigger, terminated);
            }, () -> {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context);
                this.stateTransitionBehavior.onElementTerminated(element, terminated);
            });
        }

        private void triggerProcessEventWithResultVariable(BpmnElementContext context, String resultVariableName, DirectBuffer result) {
            DirectBuffer resultVariable = ZeebeScriptBehavior.serializeToNamedVariable(resultVariableName, result);
            this.eventTriggerBehavior.triggeringProcessEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getTenantId(), context.getElementInstanceKey(), context.getElementId(), resultVariable);
        }

        private static DirectBuffer serializeToNamedVariable(String name, DirectBuffer value) {
            ExpandableArrayBuffer resultBuffer = new ExpandableArrayBuffer();
            MsgPackWriter writer = new MsgPackWriter();
            writer.wrap(resultBuffer, 0);
            writer.writeMapHeader(1);
            writer.writeString(BufferUtil.wrapString(name));
            writer.writeRaw(value);
            return resultBuffer;
        }

        private Either<Failure, DirectBuffer> evaluateScript(ExecutableScriptTask element, BpmnElementContext context) {
            Either<Failure, DirectBuffer> resultOrFailure = this.expressionProcessor.evaluateAnyExpression(element.getExpression(), context.getElementInstanceKey());
            resultOrFailure.ifRight(result -> this.triggerProcessEventWithResultVariable(context, element.getResultVariable(), (DirectBuffer)result));
            return resultOrFailure;
        }
    }

    private static interface ScriptTaskBehavior {
        public void onActivate(ExecutableScriptTask var1, BpmnElementContext var2);

        public void onComplete(ExecutableScriptTask var1, BpmnElementContext var2);

        public void onTerminate(ExecutableScriptTask var1, BpmnElementContext var2);
    }

    private static final class JobWorkerTaskBehavior
    implements ScriptTaskBehavior {
        private final JobWorkerTaskProcessor delegate;

        public JobWorkerTaskBehavior(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
            this.delegate = new JobWorkerTaskProcessor(bpmnBehaviors, stateTransitionBehavior);
        }

        @Override
        public void onActivate(ExecutableScriptTask element, BpmnElementContext activating) {
            this.delegate.onActivate(element, activating);
        }

        @Override
        public void onComplete(ExecutableScriptTask element, BpmnElementContext completing) {
            this.delegate.onComplete(element, completing);
        }

        @Override
        public void onTerminate(ExecutableScriptTask element, BpmnElementContext terminating) {
            this.delegate.onTerminate(element, terminating);
        }
    }
}

