/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.common;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElement;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.message.command.SubscriptionCommandSender;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.timer.DueDateTimerChecker;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.ProcessState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import io.camunda.zeebe.protocol.impl.SubscriptionUtil;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;

public final class CatchEventBehavior {
    private final ExpressionProcessor expressionProcessor;
    private final SubscriptionCommandSender subscriptionCommandSender;
    private final int partitionsCount;
    private final StateWriter stateWriter;
    private final SideEffectWriter sideEffectWriter;
    private final ProcessMessageSubscriptionState processMessageSubscriptionState;
    private final TimerInstanceState timerInstanceState;
    private final ProcessState processState;
    private final SignalSubscriptionState signalSubscriptionState;
    private final ProcessMessageSubscriptionRecord subscription = new ProcessMessageSubscriptionRecord();
    private final TimerRecord timerRecord = new TimerRecord();
    private final DueDateTimerChecker timerChecker;
    private final KeyGenerator keyGenerator;
    private final SignalSubscriptionRecord signalSubscription = new SignalSubscriptionRecord();

    public CatchEventBehavior(ProcessingState processingState, KeyGenerator keyGenerator, ExpressionProcessor expressionProcessor, SubscriptionCommandSender subscriptionCommandSender, StateWriter stateWriter, SideEffectWriter sideEffectWriter, DueDateTimerChecker timerChecker, int partitionsCount) {
        this.expressionProcessor = expressionProcessor;
        this.subscriptionCommandSender = subscriptionCommandSender;
        this.stateWriter = stateWriter;
        this.sideEffectWriter = sideEffectWriter;
        this.partitionsCount = partitionsCount;
        this.timerInstanceState = processingState.getTimerState();
        this.processMessageSubscriptionState = processingState.getProcessMessageSubscriptionState();
        this.processState = processingState.getProcessState();
        this.signalSubscriptionState = processingState.getSignalSubscriptionState();
        this.keyGenerator = keyGenerator;
        this.timerChecker = timerChecker;
    }

    public void unsubscribeFromEvents(long elementInstanceKey) {
        this.unsubscribeFromEvents(elementInstanceKey, elementId -> true);
    }

    public void unsubscribeEventSubprocesses(BpmnElementContext context) {
        this.unsubscribeFromEvents(context.getElementInstanceKey(), elementId -> this.isEventSubprocess(context, (DirectBuffer)elementId));
    }

    private boolean isEventSubprocess(BpmnElementContext context, DirectBuffer elementId) {
        ExecutableFlowElement element = this.processState.getFlowElement(context.getProcessDefinitionKey(), context.getTenantId(), elementId, ExecutableFlowElement.class);
        return element.getElementType() == BpmnElementType.START_EVENT && element.getFlowScope().getElementType() == BpmnElementType.EVENT_SUB_PROCESS;
    }

    private void unsubscribeFromEvents(long elementInstanceKey, Predicate<DirectBuffer> elementIdFilter) {
        this.unsubscribeFromTimerEvents(elementInstanceKey, elementIdFilter);
        this.unsubscribeFromMessageEvents(elementInstanceKey, elementIdFilter);
        this.unsubscribeFromSignalEvents(elementInstanceKey, elementIdFilter);
    }

    public Either<Failure, Void> subscribeToEvents(BpmnElementContext context, ExecutableCatchEventSupplier supplier) {
        Either evaluationResults = supplier.getEvents().stream().filter(event -> event.isTimer() || event.isMessage() || event.isSignal()).map(event -> this.evalExpressions(this.expressionProcessor, (ExecutableCatchEvent)event, context)).collect(Either.collectorFoldingLeft());
        evaluationResults.ifRight(results -> {
            this.subscribeToMessageEvents(context, (List<EvalResult>)results);
            this.subscribeToTimerEvents(context, (List<EvalResult>)results);
            this.subscribeToSignalEvents(context, (List<EvalResult>)results);
        });
        return evaluationResults.map(r -> null);
    }

    private Either<Failure, EvalResult> evalExpressions(ExpressionProcessor ep, ExecutableCatchEvent event, BpmnElementContext context) {
        return Either.right(new OngoingEvaluation(ep, event, context)).flatMap(this::evaluateMessageName).flatMap(this::evaluateCorrelationKey).flatMap(this::evaluateTimer).flatMap(this::evaluateSignalName).map(OngoingEvaluation::getResult);
    }

    private Either<Failure, OngoingEvaluation> evaluateMessageName(OngoingEvaluation evaluation) {
        ExecutableCatchEvent event = evaluation.event();
        if (!event.isMessage()) {
            return Either.right(evaluation);
        }
        long scopeKey = evaluation.context().getElementInstanceKey();
        ExecutableMessage message = event.getMessage();
        Expression messageNameExpression = message.getMessageNameExpression();
        return evaluation.expressionProcessor().evaluateStringExpression(messageNameExpression, scopeKey).map(BufferUtil::wrapString).map(evaluation::recordMessageName);
    }

    private Either<Failure, OngoingEvaluation> evaluateCorrelationKey(OngoingEvaluation evaluation) {
        ExecutableCatchEvent event = evaluation.event();
        BpmnElementContext context = evaluation.context();
        if (!event.isMessage()) {
            return Either.right(evaluation);
        }
        Expression expression = event.getMessage().getCorrelationKeyExpression();
        long scopeKey = event.getElementType() == BpmnElementType.BOUNDARY_EVENT ? context.getFlowScopeKey() : context.getElementInstanceKey();
        return evaluation.expressionProcessor().evaluateMessageCorrelationKeyExpression(expression, scopeKey).map(BufferUtil::wrapString).map(evaluation::recordCorrelationKey).mapLeft(f -> new Failure(f.getMessage(), f.getErrorType(), scopeKey));
    }

    private Either<Failure, OngoingEvaluation> evaluateTimer(OngoingEvaluation evaluation) {
        ExecutableCatchEvent event = evaluation.event();
        BpmnElementContext context = evaluation.context();
        if (!event.isTimer()) {
            return Either.right(evaluation);
        }
        long scopeKey = context.getElementInstanceKey();
        return event.getTimerFactory().apply(evaluation.expressionProcessor(), scopeKey).map(evaluation::recordTimer);
    }

    private Either<Failure, OngoingEvaluation> evaluateSignalName(OngoingEvaluation evaluation) {
        ExecutableCatchEvent event = evaluation.event();
        if (!event.isSignal()) {
            return Either.right(evaluation);
        }
        long scopeKey = evaluation.context().getElementInstanceKey();
        ExecutableSignal signal = event.getSignal();
        Expression signalNameExpression = signal.getSignalNameExpression();
        return evaluation.expressionProcessor().evaluateStringExpression(signalNameExpression, scopeKey).map(BufferUtil::wrapString).map(evaluation::recordSignalName);
    }

    private void subscribeToMessageEvents(BpmnElementContext context, List<EvalResult> results) {
        results.stream().filter(EvalResult::isMessage).forEach(result -> this.subscribeToMessageEvent(context, (EvalResult)result));
    }

    private void subscribeToMessageEvent(BpmnElementContext context, EvalResult result) {
        ExecutableCatchEvent event = result.event;
        DirectBuffer correlationKey = result.correlationKey;
        DirectBuffer messageName = result.messageName;
        long processInstanceKey = context.getProcessInstanceKey();
        DirectBuffer bpmnProcessId = BufferUtil.cloneBuffer(context.getBpmnProcessId());
        long elementInstanceKey = context.getElementInstanceKey();
        int subscriptionPartitionId = SubscriptionUtil.getSubscriptionPartitionId(correlationKey, this.partitionsCount);
        this.subscription.setSubscriptionPartitionId(subscriptionPartitionId);
        this.subscription.setMessageName(messageName);
        this.subscription.setElementInstanceKey(elementInstanceKey);
        this.subscription.setProcessInstanceKey(processInstanceKey);
        this.subscription.setBpmnProcessId(bpmnProcessId);
        this.subscription.setCorrelationKey(correlationKey);
        this.subscription.setElementId(event.getId());
        this.subscription.setInterrupting(event.isInterrupting());
        this.subscription.setTenantId(context.getTenantId());
        long subscriptionKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(subscriptionKey, ProcessMessageSubscriptionIntent.CREATING, this.subscription);
        this.sendOpenMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, bpmnProcessId, messageName, correlationKey, event.isInterrupting(), context.getTenantId());
    }

    private void subscribeToTimerEvents(BpmnElementContext context, List<EvalResult> results) {
        results.stream().filter(EvalResult::isTimer).forEach(result -> {
            ExecutableCatchEvent event = result.event;
            Timer timer = result.timer;
            this.subscribeToTimerEvent(context.getElementInstanceKey(), context.getProcessInstanceKey(), context.getProcessDefinitionKey(), event.getId(), context.getTenantId(), timer);
        });
    }

    public void subscribeToTimerEvent(long elementInstanceKey, long processInstanceKey, long processDefinitionKey, DirectBuffer handlerNodeId, String tenantId, Timer timer) {
        long dueDate = timer.getDueDate(ActorClock.currentTimeMillis());
        this.timerRecord.reset();
        this.timerRecord.setRepetitions(timer.getRepetitions()).setDueDate(dueDate).setElementInstanceKey(elementInstanceKey).setProcessInstanceKey(processInstanceKey).setTargetElementId(handlerNodeId).setProcessDefinitionKey(processDefinitionKey).setTenantId(tenantId);
        this.sideEffectWriter.appendSideEffect(() -> {
            this.timerChecker.scheduleTimer(dueDate);
            return true;
        });
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), TimerIntent.CREATED, this.timerRecord);
    }

    private void subscribeToSignalEvents(BpmnElementContext context, List<EvalResult> results) {
        results.stream().filter(EvalResult::isSignal).forEach(result -> this.subscribeToSignalEvent(context, (EvalResult)result));
    }

    private void subscribeToSignalEvent(BpmnElementContext context, EvalResult result) {
        ExecutableCatchEvent event = result.event;
        DirectBuffer signalName = result.signalName;
        this.signalSubscription.reset();
        this.signalSubscription.setSignalName(signalName).setProcessDefinitionKey(context.getProcessDefinitionKey()).setBpmnProcessId(context.getBpmnProcessId()).setCatchEventInstanceKey(context.getElementInstanceKey()).setCatchEventId(event.getId());
        long subscriptionKey = this.keyGenerator.nextKey();
        this.stateWriter.appendFollowUpEvent(subscriptionKey, SignalSubscriptionIntent.CREATED, this.signalSubscription);
    }

    private void unsubscribeFromSignalEvents(long elementInstanceKey, Predicate<DirectBuffer> elementIdFilter) {
        this.signalSubscriptionState.visitByElementInstanceKey(elementInstanceKey, subscription -> {
            DirectBuffer elementId = subscription.getRecord().getCatchEventIdBuffer();
            if (elementIdFilter.test(elementId)) {
                this.stateWriter.appendFollowUpEvent(subscription.getKey(), SignalSubscriptionIntent.DELETED, subscription.getRecord());
            }
        });
    }

    private void unsubscribeFromTimerEvents(long elementInstanceKey, Predicate<DirectBuffer> elementIdFilter) {
        this.timerInstanceState.forEachTimerForElementInstance(elementInstanceKey, timer -> {
            if (elementIdFilter.test(timer.getHandlerNodeId())) {
                this.unsubscribeFromTimerEvent((TimerInstance)timer);
            }
        });
    }

    public void unsubscribeFromTimerEvent(TimerInstance timer) {
        this.timerRecord.reset();
        this.timerRecord.setElementInstanceKey(timer.getElementInstanceKey()).setProcessInstanceKey(timer.getProcessInstanceKey()).setDueDate(timer.getDueDate()).setRepetitions(timer.getRepetitions()).setTargetElementId(timer.getHandlerNodeId()).setProcessDefinitionKey(timer.getProcessDefinitionKey()).setTenantId(timer.getTenantId());
        this.stateWriter.appendFollowUpEvent(timer.getKey(), TimerIntent.CANCELED, this.timerRecord);
    }

    private void unsubscribeFromMessageEvents(long elementInstanceKey, Predicate<DirectBuffer> elementIdFilter) {
        this.processMessageSubscriptionState.visitElementSubscriptions(elementInstanceKey, subscription -> {
            DirectBuffer elementId = subscription.getRecord().getElementIdBuffer();
            if (elementIdFilter.test(elementId)) {
                this.unsubscribeFromMessageEvent(subscription);
            }
            return true;
        });
    }

    private void unsubscribeFromMessageEvent(ProcessMessageSubscription subscription) {
        DirectBuffer messageName = BufferUtil.cloneBuffer(subscription.getRecord().getMessageNameBuffer());
        int subscriptionPartitionId = subscription.getRecord().getSubscriptionPartitionId();
        long processInstanceKey = subscription.getRecord().getProcessInstanceKey();
        long elementInstanceKey = subscription.getRecord().getElementInstanceKey();
        this.stateWriter.appendFollowUpEvent(subscription.getKey(), ProcessMessageSubscriptionIntent.DELETING, subscription.getRecord());
        this.sendCloseMessageSubscriptionCommand(subscriptionPartitionId, processInstanceKey, elementInstanceKey, messageName, subscription.getRecord().getTenantId());
    }

    private boolean sendCloseMessageSubscriptionCommand(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, String tenantId) {
        return this.subscriptionCommandSender.closeMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, messageName, tenantId);
    }

    private boolean sendOpenMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate, String tenantId) {
        return this.subscriptionCommandSender.openMessageSubscription(subscriptionPartitionId, processInstanceKey, elementInstanceKey, bpmnProcessId, messageName, correlationKey, closeOnCorrelate, tenantId);
    }

    private static class OngoingEvaluation {
        private final ExpressionProcessor expressionProcessor;
        private final ExecutableCatchEvent event;
        private final BpmnElementContext context;
        private DirectBuffer messageName;
        private DirectBuffer correlationKey;
        private Timer timer;
        private DirectBuffer signalName;

        public OngoingEvaluation(ExpressionProcessor expressionProcessor, ExecutableCatchEvent event, BpmnElementContext context) {
            this.expressionProcessor = expressionProcessor;
            this.event = event;
            this.context = context;
        }

        private ExpressionProcessor expressionProcessor() {
            return this.expressionProcessor;
        }

        private ExecutableCatchEvent event() {
            return this.event;
        }

        private BpmnElementContext context() {
            return this.context;
        }

        public OngoingEvaluation recordMessageName(DirectBuffer messageName) {
            this.messageName = messageName;
            return this;
        }

        public OngoingEvaluation recordCorrelationKey(DirectBuffer correlationKey) {
            this.correlationKey = correlationKey;
            return this;
        }

        public OngoingEvaluation recordTimer(Timer timer) {
            this.timer = timer;
            return this;
        }

        public OngoingEvaluation recordSignalName(DirectBuffer signalName) {
            this.signalName = signalName;
            return this;
        }

        EvalResult getResult() {
            return new EvalResult(this.event, this.messageName, this.correlationKey, this.timer, this.signalName);
        }
    }

    private record EvalResult(ExecutableCatchEvent event, DirectBuffer messageName, DirectBuffer correlationKey, Timer timer, DirectBuffer signalName) {
        public boolean isMessage() {
            return this.event.isMessage();
        }

        public boolean isTimer() {
            return this.event.isTimer();
        }

        public boolean isSignal() {
            return this.event.isSignal();
        }
    }
}

