/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformation;

import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableError;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableLink;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class TransformContext {
    private final Map<DirectBuffer, ExecutableProcess> processes = new HashMap<DirectBuffer, ExecutableProcess>();
    private final Map<DirectBuffer, ExecutableMessage> messages = new HashMap<DirectBuffer, ExecutableMessage>();
    private final Map<DirectBuffer, ExecutableError> errors = new HashMap<DirectBuffer, ExecutableError>();
    private final Map<DirectBuffer, ExecutableEscalation> escalations = new HashMap<DirectBuffer, ExecutableEscalation>();
    private final Map<DirectBuffer, ExecutableLink> links = new HashMap<DirectBuffer, ExecutableLink>();
    private final Map<DirectBuffer, ExecutableSignal> signals = new HashMap<DirectBuffer, ExecutableSignal>();
    private ExpressionLanguage expressionLanguage;
    private ExecutableProcess currentProcess;

    public ExecutableProcess getCurrentProcess() {
        return this.currentProcess;
    }

    public void setCurrentProcess(ExecutableProcess currentProcess) {
        this.currentProcess = currentProcess;
    }

    public void addProcess(ExecutableProcess process) {
        this.processes.put(process.getId(), process);
    }

    public ExecutableProcess getProcess(String id) {
        return this.processes.get(BufferUtil.wrapString(id));
    }

    public List<ExecutableProcess> getProcesses() {
        return new ArrayList<ExecutableProcess>(this.processes.values());
    }

    public void addMessage(ExecutableMessage message) {
        this.messages.put(message.getId(), message);
    }

    public ExecutableMessage getMessage(String id) {
        return this.messages.get(BufferUtil.wrapString(id));
    }

    public void addError(ExecutableError error2) {
        this.errors.put(error2.getId(), error2);
    }

    public ExecutableError getError(String id) {
        return this.errors.get(BufferUtil.wrapString(id));
    }

    public void addEscalation(ExecutableEscalation escalation) {
        this.escalations.put(escalation.getId(), escalation);
    }

    public ExecutableEscalation getEscalation(String id) {
        return this.escalations.get(BufferUtil.wrapString(id));
    }

    public void addLink(ExecutableLink link) {
        this.links.put(link.getName(), link);
    }

    public ExecutableLink getLink(String name) {
        return this.links.get(BufferUtil.wrapString(name));
    }

    public void addSignal(ExecutableSignal signal) {
        this.signals.put(signal.getId(), signal);
    }

    public ExecutableSignal getSignal(String id) {
        return this.signals.get(BufferUtil.wrapString(id));
    }

    public ExpressionLanguage getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(ExpressionLanguage expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }
}

