/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEscalation;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.util.buffer.BufferUtil;

public class EscalationTransformer
implements ModelElementTransformer<Escalation> {
    @Override
    public Class<Escalation> getType() {
        return Escalation.class;
    }

    @Override
    public void transform(Escalation element, TransformContext context) {
        ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
        ExecutableEscalation escalation = new ExecutableEscalation(element.getId());
        if (element.getEscalationCode() != null) {
            Expression escalationCodeExpression = expressionLanguage.parseExpression(element.getEscalationCode());
            escalation.setEscalationCodeExpression(escalationCodeExpression);
            if (escalationCodeExpression.isStatic()) {
                escalation.setEscalationCode(BufferUtil.wrapString(element.getEscalationCode()));
            }
        }
        context.addEscalation(escalation);
    }
}

