/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.transform;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.transform.DeploymentResourceTransformer;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.state.immutable.FormState;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormMetadataRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongSupplier;
import org.agrona.DirectBuffer;

public final class FormResourceTransformer
implements DeploymentResourceTransformer {
    private static final int INITIAL_VERSION = 1;
    private static final Either<Failure, Object> NO_DUPLICATES = Either.right(null);
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final Function<DeploymentResource, DirectBuffer> checksumGenerator;
    private final FormState formState;

    public FormResourceTransformer(KeyGenerator keyGenerator, StateWriter stateWriter, Function<DeploymentResource, DirectBuffer> checksumGenerator, FormState formState) {
        this.keyGenerator = keyGenerator;
        this.stateWriter = stateWriter;
        this.checksumGenerator = checksumGenerator;
        this.formState = formState;
    }

    @Override
    public Either<Failure, Void> transformResource(DeploymentResource resource, DeploymentRecord deployment) {
        return this.parseFormId(resource).flatMap(formId -> this.checkForDuplicateFormId((String)formId, resource, deployment).map(noDuplicates -> {
            FormMetadataRecord formRecord = deployment.formMetadata().add();
            this.appendMetadataToFormRecord(formRecord, (String)formId, resource, deployment.getTenantId());
            this.writeFormRecord(formRecord, resource);
            return null;
        }));
    }

    private Either<Failure, String> parseFormId(DeploymentResource resource) {
        try {
            String formId = JSON_MAPPER.readValue(resource.getResource(), FormIdPOJO.class).getId();
            return this.validateFormId(formId);
        }
        catch (JsonProcessingException e) {
            String failureMessage = String.format("Failed to parse formId from form JSON. '%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left(new Failure(failureMessage));
        }
        catch (IOException e) {
            String failureMessage = String.format("'%s': %s", resource.getResourceName(), e.getCause().getMessage());
            return Either.left(new Failure(failureMessage));
        }
    }

    private Either<Failure, ?> checkForDuplicateFormId(String formId, DeploymentResource resource, DeploymentRecord record) {
        return record.getFormMetadata().stream().filter(metadata -> metadata.getFormId().equals(formId)).findFirst().map(duplicatedForm -> {
            String failureMessage = String.format("Expected the form ids to be unique within a deployment but found a duplicated id '%s' in the resources '%s' and '%s'.", formId, duplicatedForm.getResourceName(), resource.getResourceName());
            return Either.left(new Failure(failureMessage));
        }).orElse(Either.right(null));
    }

    private void appendMetadataToFormRecord(FormMetadataRecord formRecord, String formId, DeploymentResource resource, String tenantId) {
        LongSupplier newFormKey = this.keyGenerator::nextKey;
        DirectBuffer checksum = this.checksumGenerator.apply(resource);
        formRecord.setFormId(formId);
        formRecord.setChecksum(checksum);
        formRecord.setResourceName(resource.getResourceName());
        formRecord.setTenantId(tenantId);
        this.formState.findLatestFormById(BufferUtil.wrapString(formRecord.getFormId()), tenantId).ifPresentOrElse(latestForm -> {
            boolean isDuplicate;
            int latestVersion = latestForm.getVersion();
            boolean bl = isDuplicate = latestForm.getChecksum().equals(formRecord.getChecksumBuffer()) && latestForm.getResourceName().equals(formRecord.getResourceNameBuffer());
            if (isDuplicate) {
                formRecord.setFormKey(latestForm.getFormKey()).setVersion(latestVersion).markAsDuplicate();
            } else {
                formRecord.setFormKey(newFormKey.getAsLong()).setVersion(latestVersion + 1);
            }
        }, () -> formRecord.setFormKey(newFormKey.getAsLong()).setVersion(1));
    }

    private void writeFormRecord(FormMetadataRecord formRecord, DeploymentResource resource) {
        if (!formRecord.isDuplicate()) {
            this.stateWriter.appendFollowUpEvent(formRecord.getFormKey(), FormIntent.CREATED, new FormRecord().wrap(formRecord, resource.getResource()));
        }
    }

    private Either<Failure, String> validateFormId(String formId) {
        if (formId == null) {
            return Either.left(new Failure("Expected the form id to be present, but none given"));
        }
        if (formId.isBlank()) {
            return Either.left(new Failure("Expected the form id to be filled, but it is blank"));
        }
        return Either.right(formId);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class FormIdPOJO {
        private String id;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

