/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.dmn;

import io.camunda.zeebe.dmn.DecisionEvaluationResult;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.processing.common.DecisionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.protocol.impl.record.value.decision.DecisionEvaluationRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.collection.Tuple;
import org.agrona.DirectBuffer;

public class DecisionEvaluationEvaluteProcessor
implements TypedRecordProcessor<DecisionEvaluationRecord> {
    private static final String ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED = "Expected either a decision id or a valid decision key, but none provided";
    private final DecisionBehavior decisionBehavior;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final StateWriter stateWriter;
    private final KeyGenerator keyGenerator;

    public DecisionEvaluationEvaluteProcessor(DecisionBehavior decisionBehavior, KeyGenerator keyGenerator, Writers writers) {
        this.decisionBehavior = decisionBehavior;
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
    }

    @Override
    public void processRecord(TypedRecord<DecisionEvaluationRecord> command) {
        DecisionEvaluationRecord record = (DecisionEvaluationRecord)command.getValue();
        Either<Failure, PersistedDecision> decisionOrFailure = this.getDecision(record);
        decisionOrFailure.flatMap(this.decisionBehavior::findParsedDrgByDecision).ifRightOrLeft(drg -> {
            PersistedDecision decision = (PersistedDecision)decisionOrFailure.get();
            DirectBuffer variables = record.getVariablesBuffer();
            DecisionEvaluationResult evaluationResult = this.decisionBehavior.evaluateDecisionInDrg((ParsedDecisionRequirementsGraph)drg, BufferUtil.bufferAsString(decision.getDecisionId()), variables);
            Tuple<DecisionEvaluationIntent, DecisionEvaluationRecord> evaluationRecordTuple = this.decisionBehavior.createDecisionEvaluationEvent(decision, evaluationResult);
            long evaluationRecordKey = this.keyGenerator.nextKey();
            this.stateWriter.appendFollowUpEvent(evaluationRecordKey, evaluationRecordTuple.getLeft(), evaluationRecordTuple.getRight());
            this.responseWriter.writeEventOnCommand(evaluationRecordKey, evaluationRecordTuple.getLeft(), evaluationRecordTuple.getRight(), command);
        }, failure -> {
            String reason = failure.getMessage();
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_ARGUMENT, reason);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_ARGUMENT, reason);
        });
    }

    private Either<Failure, PersistedDecision> getDecision(DecisionEvaluationRecord record) {
        String decisionId = record.getDecisionId();
        long decisionKey = record.getDecisionKey();
        if (!decisionId.isEmpty()) {
            return this.decisionBehavior.findDecisionByIdAndTenant(decisionId, record.getTenantId());
        }
        if (decisionKey > -1L) {
            return this.decisionBehavior.findDecisionByKeyAndTenant(decisionKey, record.getTenantId());
        }
        return Either.left(new Failure(ERROR_MESSAGE_NO_IDENTIFIER_SPECIFIED));
    }
}

