/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobActivationBehavior;
import io.camunda.zeebe.engine.processing.job.JobBackoffChecker;
import io.camunda.zeebe.engine.processing.job.JobCommandPreconditionChecker;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.SideEffectWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.processing.variable.VariableBehavior;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import org.agrona.DirectBuffer;

public final class JobFailProcessor
implements TypedRecordProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to cancel job with key '%d', but no such job was found";
    private static final DirectBuffer DEFAULT_ERROR_MESSAGE = BufferUtil.wrapString("No more retries left.");
    private final IncidentRecord incidentEvent = new IncidentRecord();
    private final JobState jobState;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final KeyGenerator keyGenerator;
    private final JobMetrics jobMetrics;
    private final JobBackoffChecker jobBackoffChecker;
    private final VariableBehavior variableBehavior;
    private final BpmnJobActivationBehavior jobActivationBehavior;
    private final SideEffectWriter sideEffectWriter;
    private final JobCommandPreconditionChecker preconditionChecker;

    public JobFailProcessor(ProcessingState state, Writers writers, KeyGenerator keyGenerator, JobMetrics jobMetrics, JobBackoffChecker jobBackoffChecker, BpmnBehaviors bpmnBehaviors) {
        this.jobState = state.getJobState();
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.sideEffectWriter = writers.sideEffect();
        this.variableBehavior = bpmnBehaviors.variableBehavior();
        this.jobActivationBehavior = bpmnBehaviors.jobActivationBehavior();
        this.preconditionChecker = new JobCommandPreconditionChecker("fail", List.of(JobState.State.ACTIVATABLE, JobState.State.ACTIVATED));
        this.keyGenerator = keyGenerator;
        this.jobBackoffChecker = jobBackoffChecker;
        this.jobMetrics = jobMetrics;
    }

    @Override
    public void processRecord(TypedRecord<JobRecord> record) {
        long jobKey = record.getKey();
        JobState.State state = this.jobState.getState(jobKey);
        this.preconditionChecker.check(state, jobKey).ifRightOrLeft(ok -> this.failJob(record), violation -> {
            this.rejectionWriter.appendRejection(record, (RejectionType)((Object)((Object)violation.getLeft())), (String)violation.getRight());
            this.responseWriter.writeRejectionOnCommand(record, (RejectionType)((Object)((Object)violation.getLeft())), (String)violation.getRight());
        });
    }

    private void failJob(TypedRecord<JobRecord> record) {
        boolean retryImmediately;
        long jobKey = record.getKey();
        JobRecord failJobCommandRecord = (JobRecord)record.getValue();
        int retries = failJobCommandRecord.getRetries();
        long retryBackOff = failJobCommandRecord.getRetryBackoff();
        JobRecord failedJob = this.jobState.getJob(jobKey, record.getAuthorizations());
        if (failedJob == null) {
            String errorMessage = String.format(NO_JOB_FOUND_MESSAGE, jobKey);
            this.rejectionWriter.appendRejection(record, RejectionType.NOT_FOUND, errorMessage);
            this.responseWriter.writeRejectionOnCommand(record, RejectionType.NOT_FOUND, errorMessage);
            return;
        }
        failedJob.setRetries(retries);
        failedJob.setErrorMessage(StringUtil.limitString(failJobCommandRecord.getErrorMessage(), 10000));
        failedJob.setRetryBackoff(retryBackOff);
        failedJob.setVariables(failJobCommandRecord.getVariablesBuffer());
        if (retries > 0 && retryBackOff > 0L) {
            long receivedTime = record.getTimestamp();
            failedJob.setRecurringTime(receivedTime + retryBackOff);
            this.sideEffectWriter.appendSideEffect(() -> {
                this.jobBackoffChecker.scheduleBackOff(retryBackOff + receivedTime);
                return true;
            });
        }
        this.stateWriter.appendFollowUpEvent(jobKey, JobIntent.FAILED, failedJob);
        this.responseWriter.writeEventOnCommand(jobKey, JobIntent.FAILED, failedJob, record);
        this.jobMetrics.jobFailed(failedJob.getType());
        this.setFailedVariables(failedJob);
        boolean bl = retryImmediately = retries > 0 && retryBackOff <= 0L;
        if (retryImmediately) {
            this.jobActivationBehavior.publishWork(jobKey, failedJob);
        }
        if (retries <= 0) {
            this.raiseIncident(jobKey, failedJob);
        }
    }

    private void setFailedVariables(JobRecord value) {
        DirectBuffer variables = value.getVariablesBuffer();
        if (variables.capacity() > 0) {
            this.variableBehavior.mergeLocalDocument(value.getElementInstanceKey(), value.getProcessDefinitionKey(), value.getProcessInstanceKey(), value.getBpmnProcessIdBuffer(), value.getTenantId(), variables);
        }
    }

    private void raiseIncident(long key, JobRecord value) {
        DirectBuffer jobErrorMessage = value.getErrorMessageBuffer();
        DirectBuffer incidentErrorMessage = DEFAULT_ERROR_MESSAGE;
        if (jobErrorMessage.capacity() > 0) {
            incidentErrorMessage = jobErrorMessage;
        }
        this.incidentEvent.reset();
        this.incidentEvent.setErrorType(ErrorType.JOB_NO_RETRIES).setErrorMessage(incidentErrorMessage).setBpmnProcessId(value.getBpmnProcessIdBuffer()).setProcessDefinitionKey(value.getProcessDefinitionKey()).setProcessInstanceKey(value.getProcessInstanceKey()).setElementId(value.getElementIdBuffer()).setElementInstanceKey(value.getElementInstanceKey()).setJobKey(key).setVariableScopeKey(value.getElementInstanceKey()).setTenantId(value.getTenantId());
        this.stateWriter.appendFollowUpEvent(this.keyGenerator.nextKey(), IncidentIntent.CREATED, this.incidentEvent);
    }
}

