/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.message.command;

import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.stream.api.InterPartitionCommandSender;
import org.agrona.DirectBuffer;

public class SubscriptionCommandSender {
    private final InterPartitionCommandSender interPartitionCommandSender;
    private final int senderPartition;
    private Writers writers;

    public SubscriptionCommandSender(int senderPartition, InterPartitionCommandSender interPartitionCommandSender) {
        this.senderPartition = senderPartition;
        this.interPartitionCommandSender = interPartitionCommandSender;
    }

    public boolean openMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CREATE, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(-1L).setMessageName(messageName).setCorrelationKey(correlationKey).setInterrupting(closeOnCorrelate).setTenantId(tenantId));
    }

    public void sendDirectOpenMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate, String tenantId) {
        this.interPartitionCommandSender.sendCommand(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CREATE, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(-1L).setMessageName(messageName).setCorrelationKey(correlationKey).setInterrupting(closeOnCorrelate).setTenantId(tenantId));
    }

    public boolean openProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, boolean closeOnCorrelate, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(Protocol.decodePartitionId(processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CREATE, new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName).setInterrupting(closeOnCorrelate).setTenantId(tenantId));
    }

    public boolean correlateProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, long messageKey, DirectBuffer variables, DirectBuffer correlationKey, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(Protocol.decodePartitionId(processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(messageKey).setMessageName(messageName).setVariables(variables).setCorrelationKey(correlationKey).setTenantId(tenantId));
    }

    public void sendDirectCorrelateProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, long messageKey, DirectBuffer variables, DirectBuffer correlationKey, String tenantId) {
        this.interPartitionCommandSender.sendCommand(Protocol.decodePartitionId(processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.CORRELATE, new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(messageKey).setMessageName(messageName).setVariables(variables).setCorrelationKey(correlationKey).setTenantId(tenantId));
    }

    public boolean correlateMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, DirectBuffer messageName, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.CORRELATE, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageKey(-1L).setMessageName(messageName).setTenantId(tenantId));
    }

    public boolean closeMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.DELETE, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName).setTenantId(tenantId));
    }

    public void sendDirectCloseMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, String tenantId) {
        this.interPartitionCommandSender.sendCommand(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.DELETE, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName).setTenantId(tenantId));
    }

    public boolean closeProcessMessageSubscription(long processInstanceKey, long elementInstanceKey, DirectBuffer messageName, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(Protocol.decodePartitionId(processInstanceKey), ValueType.PROCESS_MESSAGE_SUBSCRIPTION, ProcessMessageSubscriptionIntent.DELETE, new ProcessMessageSubscriptionRecord().setSubscriptionPartitionId(this.senderPartition).setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setMessageKey(-1L).setMessageName(messageName).setTenantId(tenantId));
    }

    public boolean rejectCorrelateMessageSubscription(int subscriptionPartitionId, long processInstanceKey, long elementInstanceKey, DirectBuffer bpmnProcessId, long messageKey, DirectBuffer messageName, DirectBuffer correlationKey, String tenantId) {
        return this.handleFollowUpCommandBasedOnPartition(subscriptionPartitionId, ValueType.MESSAGE_SUBSCRIPTION, MessageSubscriptionIntent.REJECT, new MessageSubscriptionRecord().setProcessInstanceKey(processInstanceKey).setElementInstanceKey(elementInstanceKey).setBpmnProcessId(bpmnProcessId).setMessageName(messageName).setCorrelationKey(correlationKey).setMessageKey(messageKey).setInterrupting(false).setTenantId(tenantId));
    }

    private boolean handleFollowUpCommandBasedOnPartition(int receiverPartitionId, ValueType valueType, Intent intent, UnifiedRecordValue record) {
        if (receiverPartitionId == this.senderPartition) {
            this.writers.command().appendNewCommand(intent, record);
        } else {
            this.writers.sideEffect().appendSideEffect(() -> {
                this.interPartitionCommandSender.sendCommand(receiverPartitionId, valueType, intent, record);
                return true;
            });
        }
        return true;
    }

    public void setWriters(Writers writers) {
        this.writers = writers;
    }
}

