/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.appliers.BufferedStartMessageEventStateApplier;
import io.camunda.zeebe.engine.state.appliers.CommandDistributionAcknowledgedApplier;
import io.camunda.zeebe.engine.state.appliers.CommandDistributionDistributingApplier;
import io.camunda.zeebe.engine.state.appliers.CommandDistributionFinishedApplier;
import io.camunda.zeebe.engine.state.appliers.CommandDistributionStartedApplier;
import io.camunda.zeebe.engine.state.appliers.DecisionCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.DecisionDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.DecisionRequirementsCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.DecisionRequirementsDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.DeploymentCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.DeploymentDistributedApplier;
import io.camunda.zeebe.engine.state.appliers.DeploymentDistributionApplier;
import io.camunda.zeebe.engine.state.appliers.DeploymentDistributionCompletedApplier;
import io.camunda.zeebe.engine.state.appliers.DeploymentFullyDistributedApplier;
import io.camunda.zeebe.engine.state.appliers.ErrorCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.FormCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.IncidentCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.IncidentResolvedApplier;
import io.camunda.zeebe.engine.state.appliers.JobBatchActivatedApplier;
import io.camunda.zeebe.engine.state.appliers.JobCanceledApplier;
import io.camunda.zeebe.engine.state.appliers.JobCompletedApplier;
import io.camunda.zeebe.engine.state.appliers.JobCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.JobErrorThrownApplier;
import io.camunda.zeebe.engine.state.appliers.JobFailedApplier;
import io.camunda.zeebe.engine.state.appliers.JobRecurredApplier;
import io.camunda.zeebe.engine.state.appliers.JobRetriesUpdatedApplier;
import io.camunda.zeebe.engine.state.appliers.JobTimedOutApplier;
import io.camunda.zeebe.engine.state.appliers.JobYieldedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageExpiredApplier;
import io.camunda.zeebe.engine.state.appliers.MessagePublishedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageStartEventSubscriptionCorrelatedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageStartEventSubscriptionCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageStartEventSubscriptionDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageSubscriptionCorrelatedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageSubscriptionCorrelatingApplier;
import io.camunda.zeebe.engine.state.appliers.MessageSubscriptionCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageSubscriptionDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.MessageSubscriptionRejectedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessDeletingApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessEventTriggeredApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessEventTriggeringApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceCreationCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementActivatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementActivatingApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementCompletedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementCompletingApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementTerminatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceElementTerminatingApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceModifiedEventApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessInstanceSequenceFlowTakenApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessMessageSubscriptionCorrelatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessMessageSubscriptionCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessMessageSubscriptionCreatingApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessMessageSubscriptionDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.ProcessMessageSubscriptionDeletingApplier;
import io.camunda.zeebe.engine.state.appliers.SignalSubscriptionCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.SignalSubscriptionDeletedApplier;
import io.camunda.zeebe.engine.state.appliers.TimerCancelledApplier;
import io.camunda.zeebe.engine.state.appliers.TimerCreatedApplier;
import io.camunda.zeebe.engine.state.appliers.TimerTriggeredApplier;
import io.camunda.zeebe.engine.state.appliers.VariableApplier;
import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableVariableState;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.intent.CommandDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionEvaluationIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionIntent;
import io.camunda.zeebe.protocol.record.intent.DecisionRequirementsIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentDistributionIntent;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.EscalationIntent;
import io.camunda.zeebe.protocol.record.intent.FormIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessEventIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceModificationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceResultIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ResourceDeletionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.protocol.record.intent.VariableDocumentIntent;
import io.camunda.zeebe.protocol.record.intent.VariableIntent;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class EventAppliers
implements EventApplier {
    public static final TypedEventApplier<Intent, RecordValue> NOOP_EVENT_APPLIER = (key, value) -> {};
    private final Map<Intent, Map<Integer, TypedEventApplier>> mapping = new HashMap<Intent, Map<Integer, TypedEventApplier>>();

    public EventAppliers registerEventAppliers(MutableProcessingState state) {
        this.registerProcessInstanceEventAppliers(state);
        this.registerProcessInstanceCreationAppliers(state);
        this.registerProcessInstanceModificationAppliers(state);
        this.register(ProcessInstanceResultIntent.COMPLETED, NOOP_EVENT_APPLIER);
        this.registerProcessAppliers(state);
        this.register(ErrorIntent.CREATED, new ErrorCreatedApplier(state.getBannedInstanceState()));
        this.registerDeploymentAppliers(state);
        this.registerMessageAppliers(state);
        this.registerMessageSubscriptionAppliers(state);
        this.registerMessageStartEventSubscriptionAppliers(state);
        this.registerJobIntentEventAppliers(state);
        this.registerVariableEventAppliers(state);
        this.register(JobBatchIntent.ACTIVATED, new JobBatchActivatedApplier(state));
        this.registerIncidentEventAppliers(state);
        this.registerProcessMessageSubscriptionEventAppliers(state);
        this.registerTimeEventAppliers(state);
        this.registerProcessEventAppliers(state);
        this.registerDecisionAppliers(state);
        this.registerDecisionRequirementsAppliers(state);
        this.registerDecisionEvaluationAppliers();
        this.registerFormAppliers(state);
        this.registerSignalAppliers(state);
        this.registerCommandDistributionAppliers(state);
        this.registerEscalationAppliers();
        this.registerResourceDeletionAppliers();
        return this;
    }

    private void registerProcessAppliers(MutableProcessingState state) {
        this.register(ProcessIntent.CREATED, new ProcessCreatedApplier(state));
        this.register(ProcessIntent.DELETING, new ProcessDeletingApplier(state));
        this.register(ProcessIntent.DELETED, new ProcessDeletedApplier(state));
    }

    private void registerTimeEventAppliers(MutableProcessingState state) {
        this.register(TimerIntent.CREATED, new TimerCreatedApplier(state.getTimerState()));
        this.register(TimerIntent.CANCELED, new TimerCancelledApplier(state.getTimerState()));
        this.register(TimerIntent.TRIGGERED, new TimerTriggeredApplier(state.getTimerState()));
    }

    private void registerDeploymentAppliers(MutableProcessingState state) {
        this.register(DeploymentDistributionIntent.DISTRIBUTING, new DeploymentDistributionApplier(state));
        this.register(DeploymentDistributionIntent.COMPLETED, new DeploymentDistributionCompletedApplier(state.getDeploymentState()));
        this.register(DeploymentIntent.CREATED, 1, new DeploymentCreatedApplier(state.getDeploymentState()));
        this.register(DeploymentIntent.CREATED, 2, NOOP_EVENT_APPLIER);
        this.register(DeploymentIntent.DISTRIBUTED, new DeploymentDistributedApplier(state.getProcessState(), state.getDecisionState()));
        this.register(DeploymentIntent.FULLY_DISTRIBUTED, new DeploymentFullyDistributedApplier(state.getDeploymentState()));
    }

    private void registerVariableEventAppliers(MutableProcessingState state) {
        VariableApplier variableApplier = new VariableApplier(state.getVariableState());
        this.register(VariableIntent.CREATED, variableApplier);
        this.register(VariableIntent.UPDATED, variableApplier);
        this.register(VariableDocumentIntent.UPDATED, NOOP_EVENT_APPLIER);
    }

    private void registerProcessInstanceEventAppliers(MutableProcessingState state) {
        MutableElementInstanceState elementInstanceState = state.getElementInstanceState();
        MutableEventScopeInstanceState eventScopeInstanceState = state.getEventScopeInstanceState();
        MutableProcessState processState = state.getProcessState();
        MutableVariableState variableState = state.getVariableState();
        BufferedStartMessageEventStateApplier bufferedStartMessageEventStateApplier = new BufferedStartMessageEventStateApplier(processState, state.getMessageState());
        this.register(ProcessInstanceIntent.ELEMENT_ACTIVATING, new ProcessInstanceElementActivatingApplier(elementInstanceState, processState, eventScopeInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_ACTIVATED, new ProcessInstanceElementActivatedApplier(elementInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_COMPLETING, new ProcessInstanceElementCompletingApplier(elementInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_COMPLETED, new ProcessInstanceElementCompletedApplier(elementInstanceState, eventScopeInstanceState, variableState, processState, bufferedStartMessageEventStateApplier));
        this.register(ProcessInstanceIntent.ELEMENT_TERMINATING, new ProcessInstanceElementTerminatingApplier(elementInstanceState));
        this.register(ProcessInstanceIntent.ELEMENT_TERMINATED, new ProcessInstanceElementTerminatedApplier(elementInstanceState, eventScopeInstanceState, bufferedStartMessageEventStateApplier));
        this.register(ProcessInstanceIntent.SEQUENCE_FLOW_TAKEN, new ProcessInstanceSequenceFlowTakenApplier(elementInstanceState, processState));
    }

    private void registerProcessInstanceCreationAppliers(MutableProcessingState state) {
        MutableProcessState processState = state.getProcessState();
        MutableElementInstanceState elementInstanceState = state.getElementInstanceState();
        this.register(ProcessInstanceCreationIntent.CREATED, new ProcessInstanceCreationCreatedApplier(processState, elementInstanceState));
    }

    private void registerProcessInstanceModificationAppliers(MutableProcessingState state) {
        this.register(ProcessInstanceModificationIntent.MODIFIED, new ProcessInstanceModifiedEventApplier(state.getElementInstanceState(), state.getProcessState()));
    }

    private void registerJobIntentEventAppliers(MutableProcessingState state) {
        this.register(JobIntent.CANCELED, new JobCanceledApplier(state));
        this.register(JobIntent.COMPLETED, new JobCompletedApplier(state));
        this.register(JobIntent.CREATED, new JobCreatedApplier(state));
        this.register(JobIntent.ERROR_THROWN, new JobErrorThrownApplier(state));
        this.register(JobIntent.FAILED, new JobFailedApplier(state));
        this.register(JobIntent.YIELDED, new JobYieldedApplier(state));
        this.register(JobIntent.RETRIES_UPDATED, new JobRetriesUpdatedApplier(state));
        this.register(JobIntent.TIMED_OUT, new JobTimedOutApplier(state));
        this.register(JobIntent.RECURRED_AFTER_BACKOFF, new JobRecurredApplier(state));
    }

    private void registerMessageAppliers(MutableProcessingState state) {
        this.register(MessageIntent.PUBLISHED, new MessagePublishedApplier(state.getMessageState()));
        this.register(MessageIntent.EXPIRED, new MessageExpiredApplier(state.getMessageState()));
    }

    private void registerMessageSubscriptionAppliers(MutableProcessingState state) {
        this.register(MessageSubscriptionIntent.CREATED, new MessageSubscriptionCreatedApplier(state.getMessageSubscriptionState()));
        this.register(MessageSubscriptionIntent.CORRELATING, new MessageSubscriptionCorrelatingApplier(state.getMessageSubscriptionState(), state.getMessageState()));
        this.register(MessageSubscriptionIntent.CORRELATED, new MessageSubscriptionCorrelatedApplier(state.getMessageSubscriptionState()));
        this.register(MessageSubscriptionIntent.REJECTED, new MessageSubscriptionRejectedApplier(state.getMessageState(), state.getMessageSubscriptionState()));
        this.register(MessageSubscriptionIntent.DELETED, new MessageSubscriptionDeletedApplier(state.getMessageSubscriptionState()));
    }

    private void registerMessageStartEventSubscriptionAppliers(MutableProcessingState state) {
        this.register(MessageStartEventSubscriptionIntent.CREATED, new MessageStartEventSubscriptionCreatedApplier(state.getMessageStartEventSubscriptionState()));
        this.register(MessageStartEventSubscriptionIntent.CORRELATED, new MessageStartEventSubscriptionCorrelatedApplier(state.getMessageState()));
        this.register(MessageStartEventSubscriptionIntent.DELETED, new MessageStartEventSubscriptionDeletedApplier(state.getMessageStartEventSubscriptionState()));
    }

    private void registerIncidentEventAppliers(MutableProcessingState state) {
        this.register(IncidentIntent.CREATED, new IncidentCreatedApplier(state.getIncidentState(), state.getJobState()));
        this.register(IncidentIntent.RESOLVED, new IncidentResolvedApplier(state.getIncidentState(), state.getJobState(), state.getElementInstanceState()));
    }

    private void registerProcessMessageSubscriptionEventAppliers(MutableProcessingState state) {
        MutableProcessMessageSubscriptionState subscriptionState = state.getProcessMessageSubscriptionState();
        this.register(ProcessMessageSubscriptionIntent.CREATING, new ProcessMessageSubscriptionCreatingApplier(subscriptionState));
        this.register(ProcessMessageSubscriptionIntent.CREATED, new ProcessMessageSubscriptionCreatedApplier(subscriptionState));
        this.register(ProcessMessageSubscriptionIntent.CORRELATED, new ProcessMessageSubscriptionCorrelatedApplier(subscriptionState));
        this.register(ProcessMessageSubscriptionIntent.DELETING, new ProcessMessageSubscriptionDeletingApplier(subscriptionState));
        this.register(ProcessMessageSubscriptionIntent.DELETED, new ProcessMessageSubscriptionDeletedApplier(subscriptionState));
    }

    private void registerProcessEventAppliers(MutableProcessingState state) {
        this.register(ProcessEventIntent.TRIGGERING, new ProcessEventTriggeringApplier(state.getEventScopeInstanceState(), state.getElementInstanceState(), state.getProcessState()));
        this.register(ProcessEventIntent.TRIGGERED, new ProcessEventTriggeredApplier(state.getEventScopeInstanceState()));
    }

    private void registerSignalAppliers(MutableProcessingState state) {
        this.register(SignalSubscriptionIntent.CREATED, new SignalSubscriptionCreatedApplier(state.getSignalSubscriptionState()));
        this.register(SignalSubscriptionIntent.DELETED, new SignalSubscriptionDeletedApplier(state.getSignalSubscriptionState()));
        this.register(SignalIntent.BROADCASTED, NOOP_EVENT_APPLIER);
    }

    private void registerDecisionAppliers(MutableProcessingState state) {
        this.register(DecisionIntent.CREATED, new DecisionCreatedApplier(state.getDecisionState()));
        this.register(DecisionIntent.DELETED, new DecisionDeletedApplier(state.getDecisionState()));
    }

    private void registerDecisionRequirementsAppliers(MutableProcessingState state) {
        this.register(DecisionRequirementsIntent.CREATED, new DecisionRequirementsCreatedApplier(state.getDecisionState()));
        this.register(DecisionRequirementsIntent.DELETED, new DecisionRequirementsDeletedApplier(state.getDecisionState()));
    }

    private void registerDecisionEvaluationAppliers() {
        this.register(DecisionEvaluationIntent.EVALUATED, NOOP_EVENT_APPLIER);
        this.register(DecisionEvaluationIntent.FAILED, NOOP_EVENT_APPLIER);
    }

    private void registerFormAppliers(MutableProcessingState state) {
        this.register(FormIntent.CREATED, new FormCreatedApplier(state));
    }

    private void registerCommandDistributionAppliers(MutableProcessingState state) {
        MutableDistributionState distributionState = state.getDistributionState();
        this.register(CommandDistributionIntent.STARTED, new CommandDistributionStartedApplier(distributionState));
        this.register(CommandDistributionIntent.DISTRIBUTING, new CommandDistributionDistributingApplier(distributionState));
        this.register(CommandDistributionIntent.ACKNOWLEDGED, new CommandDistributionAcknowledgedApplier(distributionState));
        this.register(CommandDistributionIntent.FINISHED, new CommandDistributionFinishedApplier(distributionState));
    }

    private void registerEscalationAppliers() {
        this.register(EscalationIntent.ESCALATED, NOOP_EVENT_APPLIER);
        this.register(EscalationIntent.NOT_ESCALATED, NOOP_EVENT_APPLIER);
    }

    private void registerResourceDeletionAppliers() {
        this.register(ResourceDeletionIntent.DELETING, NOOP_EVENT_APPLIER);
        this.register(ResourceDeletionIntent.DELETED, NOOP_EVENT_APPLIER);
    }

    private <I extends Intent> void register(I intent, TypedEventApplier<I, ?> applier) {
        this.register(intent, 1, applier);
    }

    <I extends Intent> void register(I intent, int version, TypedEventApplier<I, ?> applier) {
        Objects.requireNonNull(intent, "Intent must not be null");
        Objects.requireNonNull(applier, "Applier must not be null");
        if (version < 1) {
            throw new IllegalArgumentException("Version must be greater than 0");
        }
        if (!intent.isEvent()) {
            throw new IllegalArgumentException("Only event intents can be registered");
        }
        TypedEventApplier<I, ?> previousApplier = this.mapping.computeIfAbsent(intent, unused2 -> new HashMap()).putIfAbsent(version, applier);
        if (previousApplier != null) {
            throw new IllegalArgumentException(String.format("Applier for intent '%s' and version '%d' is already registered", intent, version));
        }
    }

    @Override
    public int getLatestVersion(Intent intent) {
        return ((Map)this.mapping.getOrDefault(intent, new HashMap())).keySet().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    @Override
    public void applyState(long key, Intent intent, RecordValue value, int recordVersion) throws EventApplier.NoSuchEventApplier {
        Map<Integer, TypedEventApplier> applierForIntent = this.mapping.get(intent);
        if (applierForIntent == null) {
            throw new EventApplier.NoSuchEventApplier.NoApplierForIntent(intent);
        }
        TypedEventApplier applierForVersion = applierForIntent.get(recordVersion);
        if (applierForVersion == null) {
            throw new EventApplier.NoSuchEventApplier.NoApplierForVersion(intent, recordVersion, this.getLatestVersion(intent));
        }
        applierForVersion.applyState(key, value);
    }
}

