/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import io.camunda.zeebe.protocol.record.intent.MessageStartEventSubscriptionIntent;
import org.agrona.DirectBuffer;

public final class MessageStartEventSubscriptionCorrelatedApplier
implements TypedEventApplier<MessageStartEventSubscriptionIntent, MessageStartEventSubscriptionRecord> {
    private final MutableMessageState messageState;

    public MessageStartEventSubscriptionCorrelatedApplier(MutableMessageState messageState) {
        this.messageState = messageState;
    }

    @Override
    public void applyState(long key, MessageStartEventSubscriptionRecord value) {
        this.messageState.putMessageCorrelation(value.getMessageKey(), value.getBpmnProcessIdBuffer());
        DirectBuffer correlationKey = value.getCorrelationKeyBuffer();
        if (correlationKey.capacity() > 0) {
            this.messageState.putActiveProcessInstance(value.getBpmnProcessIdBuffer(), correlationKey);
            this.messageState.putProcessInstanceCorrelationKey(value.getProcessInstanceKey(), correlationKey);
        }
    }
}

