/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class PersistedProcess
extends UnpackedObject
implements DbValue {
    private final IntegerProperty versionProp = new IntegerProperty("version", -1);
    private final LongProperty keyProp = new LongProperty("key", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty resourceProp = new BinaryProperty("resource");
    private final EnumProperty<PersistedProcessState> stateProp = new EnumProperty<PersistedProcessState>("state", PersistedProcessState.class, PersistedProcessState.ACTIVE);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public PersistedProcess() {
        super(7);
        this.declareProperty(this.versionProp).declareProperty(this.keyProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.resourceNameProp).declareProperty(this.resourceProp).declareProperty(this.stateProp).declareProperty(this.tenantIdProp);
    }

    public void wrap(ProcessRecord processRecord, long processDefinitionKey) {
        this.bpmnProcessIdProp.setValue(processRecord.getBpmnProcessIdBuffer());
        this.resourceNameProp.setValue(processRecord.getResourceNameBuffer());
        this.resourceProp.setValue(processRecord.getResourceBuffer());
        this.versionProp.setValue(processRecord.getVersion());
        this.keyProp.setValue(processDefinitionKey);
        this.tenantIdProp.setValue(processRecord.getTenantId());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getKey() {
        return this.keyProp.getValue();
    }

    public DirectBuffer getBpmnProcessId() {
        return this.bpmnProcessIdProp.getValue();
    }

    public DirectBuffer getResourceName() {
        return this.resourceNameProp.getValue();
    }

    public DirectBuffer getResource() {
        return this.resourceProp.getValue();
    }

    public PersistedProcessState getState() {
        return this.stateProp.getValue();
    }

    public PersistedProcess setState(PersistedProcessState state) {
        this.stateProp.setValue(state);
        return this;
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public PersistedProcess setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public static enum PersistedProcessState {
        ACTIVE(0),
        PENDING_DELETION(1);

        byte value;

        private PersistedProcessState(int value) {
            this.value = (byte)value;
        }
    }
}

