/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.deployment.VersionInfo;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2ObjectHashMap;

public final class VersionManager {
    private final long initialValue;
    private final ColumnFamily<DbTenantAwareKey<DbString>, VersionInfo> versionInfoColumnFamily;
    private final DbString idKey;
    private final DbString tenantIdKey;
    private final DbTenantAwareKey<DbString> tenantAwareIdKey;
    private final VersionInfo versionInfo = new VersionInfo();
    private final Object2ObjectHashMap<TenantIdAndResourceId, VersionInfo> versionByTenantCache;

    public VersionManager(long initialValue, ZeebeDb<ZbColumnFamilies> zeebeDb, ZbColumnFamilies columnFamily, TransactionContext transactionContext) {
        this.initialValue = initialValue;
        this.tenantIdKey = new DbString();
        this.idKey = new DbString();
        this.tenantAwareIdKey = new DbTenantAwareKey<DbString>(this.tenantIdKey, this.idKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.versionInfoColumnFamily = zeebeDb.createColumnFamily(columnFamily, transactionContext, this.tenantAwareIdKey, this.versionInfo);
        this.versionByTenantCache = new Object2ObjectHashMap();
    }

    private VersionInfo getVersionInfo() {
        return this.versionByTenantCache.computeIfAbsent(new TenantIdAndResourceId(this.tenantIdKey.toString(), this.idKey.toString()), key -> {
            VersionInfo persistedVersionInfo = this.versionInfoColumnFamily.get(this.tenantAwareIdKey);
            if (persistedVersionInfo == null) {
                return new VersionInfo().setHighestVersionIfHigher(this.initialValue);
            }
            return new VersionInfo(persistedVersionInfo);
        });
    }

    public void addResourceVersion(String resourceId, long value, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapString(resourceId);
        VersionInfo versionInfo = this.getVersionInfo();
        versionInfo.addKnownVersion(value);
        this.versionInfoColumnFamily.upsert(this.tenantAwareIdKey, versionInfo);
        this.versionByTenantCache.put(new TenantIdAndResourceId(tenantId, resourceId), versionInfo);
    }

    public void deleteResourceVersion(String resourceId, long version, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapString(resourceId);
        VersionInfo versionInfo = this.getVersionInfo();
        versionInfo.removeKnownVersion(version);
        this.versionInfoColumnFamily.update(this.tenantAwareIdKey, versionInfo);
        this.versionByTenantCache.put(new TenantIdAndResourceId(tenantId, resourceId), versionInfo);
    }

    public void clear() {
        this.versionByTenantCache.clear();
    }

    public long getLatestResourceVersion(String resourceId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapString(resourceId);
        return this.getVersionInfo().getLatestVersion();
    }

    public long getLatestResourceVersion(DirectBuffer resourceId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapBuffer(resourceId);
        return this.getVersionInfo().getLatestVersion();
    }

    public long getHighestResourceVersion(String resourceId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapString(resourceId);
        return this.getHighestResourceVersion();
    }

    public long getHighestResourceVersion(DirectBuffer resourceId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapBuffer(resourceId);
        return this.getHighestResourceVersion();
    }

    private long getHighestResourceVersion() {
        return this.getVersionInfo().getHighestVersion();
    }

    public Optional<Integer> findResourceVersionBefore(String resourceId, long version, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.idKey.wrapString(resourceId);
        return this.getVersionInfo().findVersionBefore(version);
    }

    private record TenantIdAndResourceId(String tenantId, String resourceId) {
    }
}

