/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.distribution.PersistedCommandDistribution;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.mutable.MutableDistributionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import org.agrona.collections.MutableBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.collections.MutableReference;
import org.slf4j.Logger;

public class DbDistributionState
implements MutableDistributionState {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final DbLong distributionKey = new DbLong();
    private final DbForeignKey<DbLong> fkDistribution = new DbForeignKey<DbLong>(this.distributionKey, ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD);
    private final DbInt partitionKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbInt> distributionPartitionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbInt>, DbNil> pendingDistributionColumnFamily;
    private final PersistedCommandDistribution persistedCommandDistribution = new PersistedCommandDistribution();
    private final ColumnFamily<DbLong, PersistedCommandDistribution> commandDistributionRecordColumnFamily;

    public DbDistributionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.commandDistributionRecordColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.COMMAND_DISTRIBUTION_RECORD, transactionContext, this.distributionKey, this.persistedCommandDistribution);
        this.partitionKey = new DbInt();
        this.distributionPartitionKey = new DbCompositeKey<DbForeignKey<DbLong>, DbInt>(this.fkDistribution, this.partitionKey);
        this.pendingDistributionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PENDING_DISTRIBUTION, transactionContext, this.distributionPartitionKey, DbNil.INSTANCE);
    }

    @Override
    public void addCommandDistribution(long distributionKey, CommandDistributionRecord commandDistributionRecord) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.insert(this.distributionKey, new PersistedCommandDistribution().wrap(commandDistributionRecord));
    }

    @Override
    public void removeCommandDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        this.commandDistributionRecordColumnFamily.deleteIfExists(this.distributionKey);
    }

    @Override
    public void addPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.insert(this.distributionPartitionKey, DbNil.INSTANCE);
    }

    @Override
    public void removePendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        this.pendingDistributionColumnFamily.deleteExisting(this.distributionPartitionKey);
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey) {
        this.distributionKey.wrapLong(distributionKey);
        MutableBoolean hasPending = new MutableBoolean();
        this.pendingDistributionColumnFamily.whileEqualPrefix((DbKey)this.distributionKey, (compositeKey, dbNil) -> {
            hasPending.set(true);
            return false;
        });
        return hasPending.get();
    }

    @Override
    public boolean hasPendingDistribution(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        this.partitionKey.wrapInt(partition);
        return this.pendingDistributionColumnFamily.exists(this.distributionPartitionKey);
    }

    @Override
    public CommandDistributionRecord getCommandDistributionRecord(long distributionKey, int partition) {
        this.distributionKey.wrapLong(distributionKey);
        PersistedCommandDistribution persistedDistribution = this.commandDistributionRecordColumnFamily.get(this.distributionKey);
        if (persistedDistribution == null) {
            return null;
        }
        return new CommandDistributionRecord().setPartitionId(partition).setValueType(persistedDistribution.getValueType()).setIntent(persistedDistribution.getIntent()).setCommandValue(persistedDistribution.getCommandValue());
    }

    @Override
    public void foreachPendingDistribution(DistributionState.PendingDistributionVisitor visitor) {
        MutableLong lastDistributionKey = new MutableLong(0L);
        MutableReference lastPendingDistribution = new MutableReference();
        this.pendingDistributionColumnFamily.forEach((compositeKey, nil) -> {
            long distributionKey = ((DbLong)((DbForeignKey)compositeKey.first()).inner()).getValue();
            int partitionId = ((DbInt)compositeKey.second()).getValue();
            if (lastDistributionKey.value != distributionKey) {
                CommandDistributionRecord pendingDistribution = this.getCommandDistributionRecord(distributionKey, partitionId);
                if (pendingDistribution == null) {
                    LOG.warn("Expected to find a pending distribution with key {} for a partition {}, but none found. The state is inconsistent", (Object)distributionKey, (Object)partitionId);
                    return;
                }
                lastDistributionKey.set(distributionKey);
                lastPendingDistribution.set(pendingDistribution);
            }
            CommandDistributionRecord commandDistributionRecord = new CommandDistributionRecord();
            commandDistributionRecord.wrap((CommandDistributionRecord)lastPendingDistribution.get()).setPartitionId(partitionId);
            visitor.visit(distributionKey, commandDistributionRecord);
        });
    }
}

