/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.distribution;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.distribution.CommandDistributionRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import org.agrona.concurrent.UnsafeBuffer;

public class PersistedCommandDistribution
extends UnpackedObject
implements DbValue {
    private final EnumProperty<ValueType> valueTypeProperty = new EnumProperty<ValueType>("valueType", ValueType.class);
    private final IntegerProperty intentProperty = new IntegerProperty("intent", 255);
    private final ObjectProperty<UnifiedRecordValue> commandValueProperty = new ObjectProperty<UnifiedRecordValue>("commandValue", new UnifiedRecordValue(10));

    public PersistedCommandDistribution() {
        super(3);
        this.declareProperty(this.valueTypeProperty).declareProperty(this.intentProperty).declareProperty(this.commandValueProperty);
    }

    public PersistedCommandDistribution wrap(CommandDistributionRecord commandDistributionRecord) {
        this.valueTypeProperty.setValue(commandDistributionRecord.getValueType());
        this.intentProperty.setValue(commandDistributionRecord.getIntent().value());
        UnifiedRecordValue commandValue = commandDistributionRecord.getCommandValue();
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = commandValue.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        commandValue.write(valueBuffer, 0);
        this.commandValueProperty.getValue().wrap(valueBuffer, 0, encodedLength);
        return this;
    }

    public ValueType getValueType() {
        return this.valueTypeProperty.getValue();
    }

    public Intent getIntent() {
        int intentValue = this.intentProperty.getValue();
        if (intentValue < 0 || intentValue > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Expected to read the intent, but it's persisted value '%d' is not a short integer", intentValue));
        }
        return Intent.fromProtocolValue(this.getValueType(), (short)intentValue);
    }

    public UnifiedRecordValue getCommandValue() {
        return this.commandValueProperty.getValue();
    }
}

