/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.metrics.BufferedMessagesMetrics;
import io.camunda.zeebe.engine.state.immutable.MessageState;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.engine.state.mutable.MutableMessageState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableBoolean;

public final class DbMessageState
implements MutableMessageState {
    public static final String DEADLINE_MESSAGE_COUNT_KEY = "deadline_message_count";
    private final ColumnFamily<DbLong, StoredMessage> messageColumnFamily;
    private final DbLong messageKey = new DbLong();
    private final DbForeignKey<DbLong> fkMessage = new DbForeignKey<DbLong>(this.messageKey, ZbColumnFamilies.MESSAGE_KEY);
    private final StoredMessage message = new StoredMessage();
    private final DbString tenantIdKey;
    private final DbString messageName;
    private final DbTenantAwareKey<DbString> tenantAwareMessageName;
    private final DbString correlationKey;
    private final DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>> nameCorrelationMessageKey;
    private final DbCompositeKey<DbTenantAwareKey<DbString>, DbString> nameAndCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>>, DbNil> nameCorrelationMessageColumnFamily;
    private final DbLong deadline;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineMessageKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlineColumnFamily;
    private final DbLong messagesDeadlineCount;
    private final DbString messagesDeadlineCountKey;
    private final ColumnFamily<DbString, DbLong> messagesDeadlineCountColumnFamily;
    private final DbString messageId;
    private final DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbString> nameCorrelationMessageIdKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbString>, DbNil> messageIdColumnFamily;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbString> messageBpmnProcessIdKey;
    private final DbString bpmnProcessIdKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbString>, DbNil> correlatedMessageColumnFamily;
    private final DbCompositeKey<DbString, DbString> bpmnProcessIdCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbString>, DbNil> activeProcessInstancesByCorrelationKeyColumnFamily;
    private final DbLong processInstanceKey;
    private final ColumnFamily<DbLong, DbString> processInstanceCorrelationKeyColumnFamily;
    private final BufferedMessagesMetrics bufferedMessagesMetrics;
    private Long localMessageDeadlineCount = 0L;

    public DbMessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.messageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_KEY, transactionContext, this.messageKey, this.message);
        this.tenantIdKey = new DbString();
        this.messageName = new DbString();
        this.tenantAwareMessageName = new DbTenantAwareKey<DbString>(this.tenantIdKey, this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey<DbTenantAwareKey<DbString>, DbString>(this.tenantAwareMessageName, this.correlationKey);
        this.nameCorrelationMessageKey = new DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbForeignKey<DbLong>>(this.nameAndCorrelationKey, this.fkMessage);
        this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGES, transactionContext, this.nameCorrelationMessageKey, DbNil.INSTANCE);
        this.deadline = new DbLong();
        this.deadlineMessageKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.deadline, this.fkMessage);
        this.deadlineColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_DEADLINES, transactionContext, this.deadlineMessageKey, DbNil.INSTANCE);
        this.messagesDeadlineCount = new DbLong();
        this.messagesDeadlineCountKey = new DbString();
        this.messagesDeadlineCountColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_STATS, transactionContext, this.messagesDeadlineCountKey, this.messagesDeadlineCount);
        this.messagesDeadlineCountKey.wrapString(DEADLINE_MESSAGE_COUNT_KEY);
        this.messageId = new DbString();
        this.nameCorrelationMessageIdKey = new DbCompositeKey<DbCompositeKey<DbTenantAwareKey<DbString>, DbString>, DbString>(this.nameAndCorrelationKey, this.messageId);
        this.messageIdColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_IDS, transactionContext, this.nameCorrelationMessageIdKey, DbNil.INSTANCE);
        this.bpmnProcessIdKey = new DbString();
        this.messageBpmnProcessIdKey = new DbCompositeKey<DbForeignKey<DbLong>, DbString>(this.fkMessage, this.bpmnProcessIdKey);
        this.correlatedMessageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_CORRELATED, transactionContext, this.messageBpmnProcessIdKey, DbNil.INSTANCE);
        this.bpmnProcessIdCorrelationKey = new DbCompositeKey<DbString, DbString>(this.bpmnProcessIdKey, this.correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_PROCESSES_ACTIVE_BY_CORRELATION_KEY, transactionContext, this.bpmnProcessIdCorrelationKey, DbNil.INSTANCE);
        this.processInstanceKey = new DbLong();
        this.processInstanceCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_PROCESS_INSTANCE_CORRELATION_KEYS, transactionContext, this.processInstanceKey, this.correlationKey);
        this.bufferedMessagesMetrics = new BufferedMessagesMetrics(partitionId);
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        if (!this.messagesDeadlineCountColumnFamily.isEmpty()) {
            this.localMessageDeadlineCount = this.messagesDeadlineCountColumnFamily.get(this.messagesDeadlineCountKey).getValue();
        }
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
    }

    @Override
    public void put(long key, MessageRecord record) {
        this.messageKey.wrapLong(key);
        this.message.setMessageKey(key).setMessage(record);
        this.messageColumnFamily.insert(this.messageKey, this.message);
        this.tenantIdKey.wrapString(record.getTenantId());
        this.messageName.wrapBuffer(record.getNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.insert(this.nameCorrelationMessageKey, DbNil.INSTANCE);
        this.deadline.wrapLong(record.getDeadline());
        this.deadlineColumnFamily.insert(this.deadlineMessageKey, DbNil.INSTANCE);
        this.localMessageDeadlineCount = this.localMessageDeadlineCount + 1L;
        this.messagesDeadlineCount.wrapLong(this.localMessageDeadlineCount);
        this.messagesDeadlineCountColumnFamily.upsert(this.messagesDeadlineCountKey, this.messagesDeadlineCount);
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
        DirectBuffer messageId = record.getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.upsert(this.nameCorrelationMessageIdKey, DbNil.INSTANCE);
        }
    }

    @Override
    public void putMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan("message key", messageKey, 0L);
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.insert(this.messageBpmnProcessIdKey, DbNil.INSTANCE);
    }

    @Override
    public void removeMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan("message key", messageKey, 0L);
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlatedMessageColumnFamily.deleteIfExists(this.messageBpmnProcessIdKey);
    }

    @Override
    public void putActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty("correlation key", correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily.insert(this.bpmnProcessIdCorrelationKey, DbNil.INSTANCE);
    }

    @Override
    public void removeActiveProcessInstance(DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty("correlation key", correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily.deleteExisting(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public void putProcessInstanceCorrelationKey(long processInstanceKey, DirectBuffer correlationKey) {
        EnsureUtil.ensureGreaterThan("process instance key", processInstanceKey, 0L);
        EnsureUtil.ensureNotNullOrEmpty("correlation key", correlationKey);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.correlationKey.wrapBuffer(correlationKey);
        this.processInstanceCorrelationKeyColumnFamily.insert(this.processInstanceKey, this.correlationKey);
    }

    @Override
    public void removeProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan("process instance key", processInstanceKey, 0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        this.processInstanceCorrelationKeyColumnFamily.deleteExisting(this.processInstanceKey);
    }

    @Override
    public void remove(long key) {
        StoredMessage storedMessage = this.getMessage(key);
        if (storedMessage == null) {
            return;
        }
        this.messageKey.wrapLong(storedMessage.getMessageKey());
        this.messageColumnFamily.deleteExisting(this.messageKey);
        this.tenantIdKey.wrapString(storedMessage.getMessage().getTenantId());
        this.messageName.wrapBuffer(storedMessage.getMessage().getNameBuffer());
        this.correlationKey.wrapBuffer(storedMessage.getMessage().getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.deleteExisting(this.nameCorrelationMessageKey);
        DirectBuffer messageId = storedMessage.getMessage().getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.deleteExisting(this.nameCorrelationMessageIdKey);
        }
        this.deadline.wrapLong(storedMessage.getMessage().getDeadline());
        this.deadlineColumnFamily.deleteExisting(this.deadlineMessageKey);
        this.localMessageDeadlineCount = this.localMessageDeadlineCount - 1L;
        this.messagesDeadlineCount.wrapLong(this.localMessageDeadlineCount);
        this.messagesDeadlineCountColumnFamily.upsert(this.messagesDeadlineCountKey, this.messagesDeadlineCount);
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
        this.correlatedMessageColumnFamily.whileEqualPrefix((DbKey)this.messageKey, (compositeKey, zbNil) -> this.correlatedMessageColumnFamily.deleteExisting((DbCompositeKey<DbForeignKey<DbLong>, DbString>)compositeKey));
    }

    @Override
    public boolean existMessageCorrelation(long messageKey, DirectBuffer bpmnProcessId) {
        EnsureUtil.ensureGreaterThan("message key", messageKey, 0L);
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        this.messageKey.wrapLong(messageKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        return this.correlatedMessageColumnFamily.exists(this.messageBpmnProcessIdKey);
    }

    @Override
    public boolean existActiveProcessInstance(String tenantId, DirectBuffer bpmnProcessId, DirectBuffer correlationKey) {
        EnsureUtil.ensureNotNullOrEmpty("BPMN process id", bpmnProcessId);
        EnsureUtil.ensureNotNullOrEmpty("correlation key", correlationKey);
        this.bpmnProcessIdKey.wrapBuffer(bpmnProcessId);
        this.correlationKey.wrapBuffer(correlationKey);
        return this.activeProcessInstancesByCorrelationKeyColumnFamily.exists(this.bpmnProcessIdCorrelationKey);
    }

    @Override
    public DirectBuffer getProcessInstanceCorrelationKey(long processInstanceKey) {
        EnsureUtil.ensureGreaterThan("process instance key", processInstanceKey, 0L);
        this.processInstanceKey.wrapLong(processInstanceKey);
        DbString correlationKey = this.processInstanceCorrelationKeyColumnFamily.get(this.processInstanceKey);
        return correlationKey != null ? correlationKey.getBuffer() : null;
    }

    @Override
    public void visitMessages(String tenantId, DirectBuffer name, DirectBuffer correlationKey, MessageState.MessageVisitor visitor) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.nameCorrelationMessageColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> {
            long messageKey = ((DbLong)((DbForeignKey)compositeKey.second()).inner()).getValue();
            StoredMessage message = this.getMessage(messageKey);
            return visitor.visit(message);
        });
    }

    @Override
    public StoredMessage getMessage(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return this.messageColumnFamily.get(this.messageKey);
    }

    @Override
    public boolean visitMessagesWithDeadlineBeforeTimestamp(long timestamp, MessageState.Index startAt, MessageState.ExpiredMessageVisitor visitor) {
        DbCompositeKey<DbLong, DbForeignKey<DbLong>> startAtKey;
        if (startAt != null) {
            this.deadline.wrapLong(startAt.deadline());
            this.messageKey.wrapLong(startAt.key());
            startAtKey = this.deadlineMessageKey;
        } else {
            startAtKey = null;
        }
        MutableBoolean stoppedByVisitor = new MutableBoolean(false);
        this.deadlineColumnFamily.whileTrue(startAtKey, (key, value) -> {
            boolean shouldContinue = false;
            long deadlineEntry = ((DbLong)key.first()).getValue();
            if (deadlineEntry <= timestamp) {
                long messageKeyEntry = ((DbLong)((DbForeignKey)key.second()).inner()).getValue();
                shouldContinue = visitor.visit(deadlineEntry, messageKeyEntry);
                stoppedByVisitor.set(!shouldContinue);
            }
            return shouldContinue;
        });
        return stoppedByVisitor.get();
    }

    @Override
    public boolean exist(DirectBuffer name, DirectBuffer correlationKey, DirectBuffer messageId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageId.wrapBuffer(messageId);
        return this.messageIdColumnFamily.exists(this.nameCorrelationMessageIdKey);
    }
}

