/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.engine.state.migration.DbMigrator;
import io.camunda.zeebe.engine.state.migration.JobBackoffCleanupMigration;
import io.camunda.zeebe.engine.state.migration.JobBackoffRestoreMigration;
import io.camunda.zeebe.engine.state.migration.JobTimeoutCleanupMigration;
import io.camunda.zeebe.engine.state.migration.MessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.MigrationTask;
import io.camunda.zeebe.engine.state.migration.ProcessMessageSubscriptionSentTimeMigration;
import io.camunda.zeebe.engine.state.migration.TemporaryVariableMigration;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_2.DecisionRequirementsMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.ColumnFamilyPrefixCorrectionMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyDecisionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyJobStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStartEventSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessMessageSubscriptionStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.MultiTenancyProcessStateMigration;
import io.camunda.zeebe.engine.state.migration.to_8_3.ProcessInstanceByProcessDefinitionMigration;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigratorImpl
implements DbMigrator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbMigratorImpl.class.getPackageName());
    private static final List<MigrationTask> MIGRATION_TASKS = List.of(new ProcessMessageSubscriptionSentTimeMigration(), new MessageSubscriptionSentTimeMigration(), new TemporaryVariableMigration(), new DecisionMigration(), new DecisionRequirementsMigration(), new ProcessInstanceByProcessDefinitionMigration(), new JobTimeoutCleanupMigration(), new JobBackoffCleanupMigration(), new MultiTenancyProcessStateMigration(), new MultiTenancyDecisionStateMigration(), new MultiTenancyMessageStateMigration(), new MultiTenancyMessageStartEventSubscriptionStateMigration(), new MultiTenancyMessageSubscriptionStateMigration(), new MultiTenancyProcessMessageSubscriptionStateMigration(), new MultiTenancyJobStateMigration(), new ColumnFamilyPrefixCorrectionMigration(), new JobBackoffRestoreMigration());
    private final MutableProcessingState processingState;
    private final List<MigrationTask> migrationTasks;

    public DbMigratorImpl(MutableProcessingState processingState) {
        this(processingState, MIGRATION_TASKS);
    }

    public DbMigratorImpl(MutableProcessingState processingState, List<MigrationTask> migrationTasks) {
        this.processingState = processingState;
        this.migrationTasks = migrationTasks;
    }

    @Override
    public void runMigrations() {
        this.logPreview(this.migrationTasks);
        ArrayList<MigrationTask> executedMigrations = new ArrayList<MigrationTask>();
        for (int index = 1; index <= this.migrationTasks.size(); ++index) {
            MigrationTask migration2 = this.migrationTasks.get(index - 1);
            boolean executed = this.handleMigrationTask(migration2, index, this.migrationTasks.size());
            if (!executed) continue;
            executedMigrations.add(migration2);
        }
        this.logSummary(executedMigrations);
    }

    private void logPreview(List<MigrationTask> migrationTasks) {
        LOGGER.info("Starting processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Found " + migrationTasks.size() + " migration tasks: " + migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    private void logSummary(List<MigrationTask> migrationTasks) {
        LOGGER.info("Completed processing of migration tasks (use LogLevel.DEBUG for more details) ... ");
        LOGGER.debug("Executed " + migrationTasks.size() + " migration tasks: " + migrationTasks.stream().map(MigrationTask::getIdentifier).collect(Collectors.joining(", ")));
    }

    private boolean handleMigrationTask(MigrationTask migrationTask, int index, int total) {
        if (migrationTask.needsToRun(this.processingState)) {
            this.runMigration(migrationTask, index, total);
            return true;
        }
        this.logMigrationSkipped(migrationTask, index, total);
        return false;
    }

    private void logMigrationSkipped(MigrationTask migrationTask, int index, int total) {
        LOGGER.info("Skipping " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ").  It was determined it does not need to run right now.");
    }

    private void runMigration(MigrationTask migrationTask, int index, int total) {
        LOGGER.info("Starting " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ")");
        long startTime = System.currentTimeMillis();
        migrationTask.runMigration(this.processingState);
        long duration = System.currentTimeMillis() - startTime;
        LOGGER.debug(migrationTask.getIdentifier() + " migration completed in " + duration + " ms.");
        LOGGER.info("Finished " + migrationTask.getIdentifier() + " migration (" + index + "/" + total + ")");
    }
}

