/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import java.util.function.BiConsumer;
import org.agrona.collections.MutableLong;

public final class MemoryBoundedColumnIteration {
    private static final long DEFAULT_MEMORY_LIMIT = 0x3200000L;
    private final long memoryLimitBytes;

    public MemoryBoundedColumnIteration() {
        this(0x3200000L);
    }

    public MemoryBoundedColumnIteration(long memoryLimitBytes) {
        this.memoryLimitBytes = memoryLimitBytes;
    }

    public <KeyT extends DbKey, ValueT extends DbValue> void drain(ColumnFamily<KeyT, ValueT> columnFamily, BiConsumer<KeyT, ValueT> consumer) {
        while (!columnFamily.isEmpty()) {
            MutableLong memoryUsage = new MutableLong();
            columnFamily.whileTrue((key, value) -> {
                consumer.accept(key, value);
                columnFamily.deleteExisting(key);
                return memoryUsage.addAndGet(key.getLength() + value.getLength()) < this.memoryLimitBytes;
            });
        }
    }
}

