/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyJobState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbJobMigrationState {
    private final LegacyJobState from;
    private final DbJobState to;

    public DbJobMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacyJobState(zeebeDb, transactionContext);
        this.to = new DbJobState(zeebeDb, transactionContext);
    }

    public void migrateJobStateForMultiTenancy() {
        MemoryBoundedColumnIteration iterator = new MemoryBoundedColumnIteration();
        this.to.tenantIdKey.wrapString("<default>");
        iterator.drain(this.from.getActivatableColumnFamily(), (key, value) -> {
            this.to.jobTypeKey.wrapString(((DbString)key.first()).toString());
            this.to.fkJob.inner().wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            this.to.activatableColumnFamily.insert(this.to.tenantAwareTypeJobKey, DbNil.INSTANCE);
        });
    }

    private static final class DbJobState {
        private final DbLong jobKey = new DbLong();
        private final DbForeignKey<DbLong> fkJob = new DbForeignKey<DbLong>(this.jobKey, ZbColumnFamilies.JOBS);
        private final DbString jobTypeKey = new DbString();
        private final DbString tenantIdKey = new DbString();
        private final DbCompositeKey<DbString, DbForeignKey<DbLong>> typeJobKey = new DbCompositeKey<DbString, DbForeignKey<DbLong>>(this.jobTypeKey, this.fkJob);
        private final DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>> tenantAwareTypeJobKey = new DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>(this.tenantIdKey, this.typeJobKey, DbTenantAwareKey.PlacementType.SUFFIX);
        private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbForeignKey<DbLong>>>, DbNil> activatableColumnFamily;

        public DbJobState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.activatableColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.JOB_ACTIVATABLE, transactionContext, this.tenantAwareTypeJobKey, DbNil.INSTANCE);
        }
    }
}

