/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbMessageSubscriptionMigrationState {
    private final LegacyMessageSubscriptionState from;
    private final DbMessageSubscriptionState to;

    public DbMessageSubscriptionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacyMessageSubscriptionState(zeebeDb, transactionContext);
        this.to = new DbMessageSubscriptionState(zeebeDb, transactionContext);
    }

    public void migrateMessageSubscriptionForMultiTenancy() {
        MemoryBoundedColumnIteration iterator = new MemoryBoundedColumnIteration();
        this.to.tenantIdKey.wrapString("<default>");
        iterator.drain(this.from.getMessageNameAndCorrelationKeyColumnFamily(), (key, value) -> {
            this.to.messageName.wrapBuffer(((DbString)((DbCompositeKey)key.first()).first()).getBuffer());
            this.to.correlationKey.wrapBuffer(((DbString)((DbCompositeKey)key.first()).second()).getBuffer());
            this.to.elementInstanceKey.wrapLong(((DbLong)key.second()).getValue());
            this.to.messageNameAndCorrelationKeyColumnFamily.insert(this.to.tenantAwareNameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
        });
    }

    private static final class DbMessageSubscriptionState {
        private final DbLong elementInstanceKey = new DbLong();
        private final DbString messageName = new DbString();
        private final MessageSubscription messageSubscription = new MessageSubscription();
        private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.elementInstanceKey, this.messageName);
        private final ColumnFamily<DbCompositeKey<DbLong, DbString>, MessageSubscription> subscriptionColumnFamily;
        private final DbString tenantIdKey;
        private final DbString correlationKey;
        private final DbTenantAwareKey<DbCompositeKey<DbString, DbString>> tenantAwareNameAndCorrelationKey;
        private final DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong> tenantAwareNameCorrelationAndElementInstanceKey;
        private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;

        public DbMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.subscriptionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, this.messageSubscription);
            this.tenantIdKey = new DbString();
            this.correlationKey = new DbString();
            this.tenantAwareNameAndCorrelationKey = new DbTenantAwareKey<DbCompositeKey<DbString, DbString>>(this.tenantIdKey, new DbCompositeKey<DbString, DbString>(this.messageName, this.correlationKey), DbTenantAwareKey.PlacementType.PREFIX);
            this.tenantAwareNameCorrelationAndElementInstanceKey = new DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong>(this.tenantAwareNameAndCorrelationKey, this.elementInstanceKey);
            this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, transactionContext, this.tenantAwareNameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
        }
    }
}

