/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.MemoryBoundedColumnIteration;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbProcessMessageSubscriptionMigrationState {
    private final LegacyProcessMessageSubscriptionState from;
    private final DbProcessMessageSubscriptionState to;

    public DbProcessMessageSubscriptionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacyProcessMessageSubscriptionState(zeebeDb, transactionContext);
        this.to = new DbProcessMessageSubscriptionState(zeebeDb, transactionContext);
    }

    public void migrateProcessMessageSubscriptionForMultiTenancy() {
        MemoryBoundedColumnIteration iterator = new MemoryBoundedColumnIteration();
        this.to.tenantIdKey.wrapString("<default>");
        iterator.drain(this.from.getSubscriptionColumnFamily(), (key, value) -> {
            this.to.elementInstanceKey.wrapLong(((DbLong)key.first()).getValue());
            this.to.messageName.wrapBuffer(((DbString)key.second()).getBuffer());
            value.getRecord().setTenantId("<default>");
            this.to.subscriptionColumnFamily.insert(this.to.elementKeyAndMessageName, (ProcessMessageSubscription)value);
        });
    }

    private static final class DbProcessMessageSubscriptionState {
        private final DbLong elementInstanceKey = new DbLong();
        private final DbString tenantIdKey = new DbString();
        private final DbString messageName = new DbString();
        private final DbTenantAwareKey<DbString> tenantAwareMessageName = new DbTenantAwareKey<DbString>(this.tenantIdKey, this.messageName, DbTenantAwareKey.PlacementType.PREFIX);
        private final DbCompositeKey<DbLong, DbTenantAwareKey<DbString>> elementKeyAndMessageName = new DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>(this.elementInstanceKey, this.tenantAwareMessageName);
        private final ProcessMessageSubscription processMessageSubscription = new ProcessMessageSubscription();
        private final ColumnFamily<DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>, ProcessMessageSubscription> subscriptionColumnFamily;

        public DbProcessMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.subscriptionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, this.processMessageSubscription);
        }
    }
}

