/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.dmn.DecisionEngine;
import io.camunda.zeebe.dmn.DecisionEngineFactory;
import io.camunda.zeebe.dmn.ParsedDecisionRequirementsGraph;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.deployment.DeployedDrg;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRequirementsRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.agrona.DirectBuffer;

public final class LegacyDecisionState {
    private final DecisionEngine decisionEngine = DecisionEngineFactory.createDecisionEngine();
    private final DbLong dbDecisionKey = new DbLong();
    private final DbForeignKey<DbLong> fkDecision = new DbForeignKey<DbLong>(this.dbDecisionKey, ZbColumnFamilies.DEPRECATED_DMN_DECISIONS);
    private final PersistedDecision dbPersistedDecision = new PersistedDecision();
    private final DbString dbDecisionId;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbString dbDecisionRequirementsId;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> dbDecisionRequirementsKeyAndDecisionKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> decisionKeyByDecisionRequirementsKey;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionKeysByDecisionId;
    private final DbInt dbDecisionVersion;
    private final DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKey;
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> latestDecisionRequirementsKeysById;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersion;
    private final LoadingCache<Long, DeployedDrg> drgCache;

    public LegacyDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, EngineConfiguration config) {
        this.decisionsByKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISIONS, transactionContext, this.dbDecisionKey, this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.latestDecisionKeysByDecisionId = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_LATEST_DECISION_BY_ID, transactionContext, this.dbDecisionId, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey<DbLong>(this.dbDecisionRequirementsKey, ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS, transactionContext, this.dbDecisionRequirementsKey, this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId = new DbString();
        this.latestDecisionRequirementsKeysById = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_LATEST_DECISION_REQUIREMENTS_BY_ID, transactionContext, this.dbDecisionRequirementsId, this.fkDecisionRequirements);
        this.dbDecisionRequirementsKeyAndDecisionKey = new DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>(this.fkDecisionRequirements, this.fkDecision);
        this.decisionKeyByDecisionRequirementsKey = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_REQUIREMENTS_KEY, transactionContext, this.dbDecisionRequirementsKeyAndDecisionKey, DbNil.INSTANCE);
        this.dbDecisionVersion = new DbInt();
        this.decisionIdAndVersion = new DbCompositeKey<DbString, DbInt>(this.dbDecisionId, this.dbDecisionVersion);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.decisionIdAndVersion, this.fkDecision);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey<DbString, DbInt>(this.dbDecisionRequirementsId, this.dbDecisionRequirementsVersion);
        this.decisionRequirementsKeyByIdAndVersion = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.drgCache = CacheBuilder.newBuilder().maximumSize(config.getDrgCacheCapacity()).build(new CacheLoader<Long, DeployedDrg>(){

            @Override
            public DeployedDrg load(Long key) throws DrgNotFoundException {
                return LegacyDecisionState.this.findAndParseDecisionRequirementsByKeyFromDb(key);
            }
        });
    }

    public Optional<PersistedDecision> findLatestDecisionById(DirectBuffer decisionId) {
        this.dbDecisionId.wrapBuffer(decisionId);
        return Optional.ofNullable(this.latestDecisionKeysByDecisionId.get(this.dbDecisionId)).flatMap(decisionKey -> this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()));
    }

    public Optional<PersistedDecision> findDecisionByKey(long decisionKey) {
        this.dbDecisionKey.wrapLong(decisionKey);
        return Optional.ofNullable(this.decisionsByKey.get(this.dbDecisionKey)).map(PersistedDecision::copy);
    }

    public Optional<DeployedDrg> findLatestDecisionRequirementsById(DirectBuffer decisionRequirementsId) {
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        return Optional.ofNullable(this.latestDecisionRequirementsKeysById.get(this.dbDecisionRequirementsId)).map(requirementsKey -> ((DbLong)requirementsKey.inner()).getValue()).flatMap(this::findDecisionRequirementsByKey);
    }

    public Optional<DeployedDrg> findDecisionRequirementsByKey(long decisionRequirementsKey) {
        return this.findDeployedDrg(decisionRequirementsKey);
    }

    public List<PersistedDecision> findDecisionsByDecisionRequirementsKey(long decisionRequirementsKey) {
        ArrayList<PersistedDecision> decisions = new ArrayList<PersistedDecision>();
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        this.decisionKeyByDecisionRequirementsKey.whileEqualPrefix((DbKey)this.dbDecisionRequirementsKey, (key, nil) -> {
            DbForeignKey decisionKey = (DbForeignKey)key.second();
            this.findDecisionByKey(((DbLong)decisionKey.inner()).getValue()).ifPresent(decisions::add);
        });
        return decisions;
    }

    public void clearCache() {
        this.drgCache.invalidateAll();
    }

    private DeployedDrg findAndParseDecisionRequirementsByKeyFromDb(long decisionRequirementsKey) throws DrgNotFoundException {
        this.dbDecisionRequirementsKey.wrapLong(decisionRequirementsKey);
        PersistedDecisionRequirements persistedDrg = this.decisionRequirementsByKey.get(this.dbDecisionRequirementsKey);
        if (persistedDrg == null) {
            throw new DrgNotFoundException();
        }
        PersistedDecisionRequirements copiedDrg = persistedDrg.copy();
        byte[] resourceBytes = BufferUtil.bufferAsArray(copiedDrg.getResource());
        ParsedDecisionRequirementsGraph parsedDrg = this.decisionEngine.parse(new ByteArrayInputStream(resourceBytes));
        return new DeployedDrg(parsedDrg, copiedDrg);
    }

    private Optional<DeployedDrg> findDeployedDrg(long decisionRequirementsKey) {
        try {
            return Optional.of(this.drgCache.get(decisionRequirementsKey));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    private Optional<Long> findPreviousVersionDecisionKey(DirectBuffer decisionId, int currentVersion) {
        HashMap decisionKeysByVersion = new HashMap();
        this.dbDecisionId.wrapBuffer(decisionId);
        this.decisionKeyByDecisionIdAndVersion.whileEqualPrefix((DbKey)this.dbDecisionId, (key, decisionKey) -> {
            if (((DbInt)key.second()).getValue() < currentVersion) {
                decisionKeysByVersion.put(((DbInt)key.second()).getValue(), ((DbLong)decisionKey.inner()).getValue());
            }
        });
        if (decisionKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionKeysByVersion.keySet());
        return Optional.of((Long)decisionKeysByVersion.get(previousVersion));
    }

    private Optional<Long> findPreviousVersionDecisionRequirementsKey(DirectBuffer decisionRequirementsId, int currentVersion) {
        HashMap decisionRequirementsKeysByVersion = new HashMap();
        this.dbDecisionRequirementsId.wrapBuffer(decisionRequirementsId);
        this.decisionRequirementsKeyByIdAndVersion.whileEqualPrefix((DbKey)this.dbDecisionRequirementsId, (key, drgKey) -> {
            if (((DbInt)key.second()).getValue() < currentVersion) {
                decisionRequirementsKeysByVersion.put(((DbInt)key.second()).getValue(), ((DbLong)drgKey.inner()).getValue());
            }
        });
        if (decisionRequirementsKeysByVersion.isEmpty()) {
            return Optional.empty();
        }
        Integer previousVersion = (Integer)Collections.max(decisionRequirementsKeysByVersion.keySet());
        return Optional.of((Long)decisionRequirementsKeysByVersion.get(previousVersion));
    }

    public void storeDecisionRecord(DecisionRecord record) {
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbPersistedDecision.wrap(record);
        this.decisionsByKey.upsert(this.dbDecisionKey, this.dbPersistedDecision);
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.decisionKeyByDecisionRequirementsKey.upsert(this.dbDecisionRequirementsKeyAndDecisionKey, DbNil.INSTANCE);
        this.dbDecisionId.wrapString(record.getDecisionId());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionIdAndVersion.upsert(this.decisionIdAndVersion, this.fkDecision);
        this.updateLatestDecisionVersion(record);
    }

    public void storeDecisionRequirements(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbPersistedDecisionRequirements.wrap(record);
        this.decisionRequirementsByKey.upsert(this.dbDecisionRequirementsKey, this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsId.wrapString(record.getDecisionRequirementsId());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsKeyByIdAndVersion.upsert(this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.updateLatestDecisionRequirementsVersion(record);
    }

    public void deleteDecision(DecisionRecord record) {
        this.findLatestDecisionById(record.getDecisionIdBuffer()).map(PersistedDecision::getVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getVersion()) {
                this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
                this.findPreviousVersionDecisionKey(record.getDecisionIdBuffer(), record.getVersion()).ifPresentOrElse(previousDecisionKey -> {
                    this.dbDecisionKey.wrapLong((long)previousDecisionKey);
                    this.latestDecisionKeysByDecisionId.update(this.dbDecisionId, this.fkDecision);
                }, () -> this.latestDecisionKeysByDecisionId.deleteExisting(this.dbDecisionId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionVersion.wrapInt(record.getVersion());
        this.decisionKeyByDecisionRequirementsKey.deleteExisting(this.dbDecisionRequirementsKeyAndDecisionKey);
        this.decisionsByKey.deleteExisting(this.dbDecisionKey);
        this.decisionKeyByDecisionIdAndVersion.deleteExisting(this.decisionIdAndVersion);
    }

    public void deleteDecisionRequirements(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsById(record.getDecisionRequirementsIdBuffer()).map(DeployedDrg::getDecisionRequirementsVersion).ifPresent(latestVersion -> {
            if (latestVersion.intValue() == record.getDecisionRequirementsVersion()) {
                this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
                this.findPreviousVersionDecisionRequirementsKey(record.getDecisionRequirementsIdBuffer(), record.getDecisionRequirementsVersion()).ifPresentOrElse(previousDrgKey -> {
                    this.dbDecisionRequirementsKey.wrapLong((long)previousDrgKey);
                    this.latestDecisionRequirementsKeysById.update(this.dbDecisionRequirementsId, this.fkDecisionRequirements);
                }, () -> this.latestDecisionRequirementsKeysById.deleteExisting(this.dbDecisionRequirementsId));
            }
        });
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsVersion.wrapInt(record.getDecisionRequirementsVersion());
        this.decisionRequirementsByKey.deleteExisting(this.dbDecisionRequirementsKey);
        this.decisionRequirementsKeyByIdAndVersion.deleteExisting(this.decisionRequirementsIdAndVersion);
    }

    private void updateLatestDecisionVersion(DecisionRecord record) {
        this.findLatestDecisionById(record.getDecisionIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getVersion() > previousVersion.getVersion()) {
                this.updateDecisionAsLatestVersion(record);
            }
        }, () -> this.insertDecisionAsLatestVersion(record));
    }

    private void updateDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.update(this.dbDecisionId, this.fkDecision);
    }

    private void insertDecisionAsLatestVersion(DecisionRecord record) {
        this.dbDecisionId.wrapBuffer(record.getDecisionIdBuffer());
        this.dbDecisionKey.wrapLong(record.getDecisionKey());
        this.latestDecisionKeysByDecisionId.upsert(this.dbDecisionId, this.fkDecision);
    }

    private void updateLatestDecisionRequirementsVersion(DecisionRequirementsRecord record) {
        this.findLatestDecisionRequirementsById(record.getDecisionRequirementsIdBuffer()).ifPresentOrElse(previousVersion -> {
            if (record.getDecisionRequirementsVersion() > previousVersion.getDecisionRequirementsVersion()) {
                this.updateDecisionRequirementsAsLatestVersion(record);
            }
        }, () -> this.insertDecisionRequirementsAsLatestVersion(record));
    }

    private void updateDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.update(this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }

    private void insertDecisionRequirementsAsLatestVersion(DecisionRequirementsRecord record) {
        this.dbDecisionRequirementsId.wrapBuffer(record.getDecisionRequirementsIdBuffer());
        this.dbDecisionRequirementsKey.wrapLong(record.getDecisionRequirementsKey());
        this.latestDecisionRequirementsKeysById.upsert(this.dbDecisionRequirementsId, this.fkDecisionRequirements);
    }

    public ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> getDecisionKeyByDecisionRequirementsKey() {
        return this.decisionKeyByDecisionRequirementsKey;
    }

    public ColumnFamily<DbLong, PersistedDecision> getDecisionsByKey() {
        return this.decisionsByKey;
    }

    public ColumnFamily<DbString, DbForeignKey<DbLong>> getLatestDecisionKeysByDecisionId() {
        return this.latestDecisionKeysByDecisionId;
    }

    public ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> getDecisionKeyByDecisionIdAndVersion() {
        return this.decisionKeyByDecisionIdAndVersion;
    }

    public ColumnFamily<DbLong, PersistedDecisionRequirements> getDecisionRequirementsByKey() {
        return this.decisionRequirementsByKey;
    }

    public ColumnFamily<DbString, DbForeignKey<DbLong>> getLatestDecisionRequirementsKeysById() {
        return this.latestDecisionRequirementsKeysById;
    }

    public ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> getDecisionRequirementsKeyByIdAndVersion() {
        return this.decisionRequirementsKeyByIdAndVersion;
    }

    private static final class DrgNotFoundException
    extends Exception {
        private DrgNotFoundException() {
        }
    }
}

