/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.message.MessageStartEventSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;

public final class LegacyMessageStartEventSubscriptionState {
    private final DbString messageName;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbString, DbLong> messageNameAndProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, MessageStartEventSubscription> subscriptionsColumnFamily;
    private final MessageStartEventSubscription messageStartEventSubscription = new MessageStartEventSubscription();
    private final DbCompositeKey<DbLong, DbString> processDefinitionKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionsOfProcessDefinitionKeyColumnFamily;

    public LegacyMessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageName = new DbString();
        this.processDefinitionKey = new DbLong();
        this.messageNameAndProcessDefinitionKey = new DbCompositeKey<DbString, DbLong>(this.messageName, this.processDefinitionKey);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.messageNameAndProcessDefinitionKey, this.messageStartEventSubscription);
        this.processDefinitionKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.processDefinitionKey, this.messageName);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.processDefinitionKeyAndMessageName, DbNil.INSTANCE);
    }

    public void put(long key, MessageStartEventSubscriptionRecord subscription) {
        this.messageStartEventSubscription.setKey(key).setRecord(subscription);
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.processDefinitionKey.wrapLong(subscription.getProcessDefinitionKey());
        this.subscriptionsColumnFamily.upsert(this.messageNameAndProcessDefinitionKey, this.messageStartEventSubscription);
        this.subscriptionsOfProcessDefinitionKeyColumnFamily.upsert(this.processDefinitionKeyAndMessageName, DbNil.INSTANCE);
    }

    public ColumnFamily<DbCompositeKey<DbString, DbLong>, MessageStartEventSubscription> getSubscriptionsColumnFamily() {
        return this.subscriptionsColumnFamily;
    }

    public ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> getSubscriptionsOfProcessDefinitionKeyColumnFamily() {
        return this.subscriptionsOfProcessDefinitionKeyColumnFamily;
    }
}

