/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class LegacyProcessMessageSubscriptionState {
    private final DbLong elementInstanceKey = new DbLong();
    private final DbString messageName = new DbString();
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.elementInstanceKey, this.messageName);
    private final ProcessMessageSubscription processMessageSubscription = new ProcessMessageSubscription();
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, ProcessMessageSubscription> subscriptionColumnFamily;

    public LegacyProcessMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_PROCESS_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, this.processMessageSubscription);
    }

    public void put(long key, ProcessMessageSubscriptionRecord record) {
        this.wrapSubscriptionKeys(record.getElementInstanceKey(), record.getMessageNameBuffer());
        this.processMessageSubscription.reset();
        this.processMessageSubscription.setKey(key).setRecord(record);
        this.subscriptionColumnFamily.insert(this.elementKeyAndMessageName, this.processMessageSubscription);
    }

    private void wrapSubscriptionKeys(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
    }

    public ColumnFamily<DbCompositeKey<DbLong, DbString>, ProcessMessageSubscription> getSubscriptionColumnFamily() {
        return this.subscriptionColumnFamily;
    }
}

