/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.signal;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.SignalSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableSignalSubscriptionState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import org.agrona.DirectBuffer;

public final class DbSignalSubscriptionState
implements MutableSignalSubscriptionState {
    private final DbString signalName;
    private final DbLong subscriptionKey;
    private final DbCompositeKey<DbString, DbLong> signalNameAndSubscriptionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, SignalSubscription> signalNameAndSubscriptionKeyColumnFamily;
    private final SignalSubscription signalSubscription = new SignalSubscription();
    private final DbCompositeKey<DbLong, DbString> subscriptionKeyAndSignalName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionKeyAndSignalNameColumnFamily;

    public DbSignalSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.signalName = new DbString();
        this.subscriptionKey = new DbLong();
        this.signalNameAndSubscriptionKey = new DbCompositeKey<DbString, DbLong>(this.signalName, this.subscriptionKey);
        this.signalNameAndSubscriptionKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.signalNameAndSubscriptionKey, this.signalSubscription);
        this.subscriptionKeyAndSignalName = new DbCompositeKey<DbLong, DbString>(this.subscriptionKey, this.signalName);
        this.subscriptionKeyAndSignalNameColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.subscriptionKeyAndSignalName, DbNil.INSTANCE);
    }

    @Override
    public void put(long key, SignalSubscriptionRecord subscription) {
        this.signalSubscription.setKey(key).setRecord(subscription);
        this.wrapSubscriptionKeys(subscription);
        this.signalNameAndSubscriptionKeyColumnFamily.upsert(this.signalNameAndSubscriptionKey, this.signalSubscription);
        this.subscriptionKeyAndSignalNameColumnFamily.upsert(this.subscriptionKeyAndSignalName, DbNil.INSTANCE);
    }

    @Override
    public void remove(long subscriptionKey, DirectBuffer signalName) {
        this.wrapSubscriptionKeys(subscriptionKey, signalName);
        this.signalNameAndSubscriptionKeyColumnFamily.deleteExisting(this.signalNameAndSubscriptionKey);
        this.subscriptionKeyAndSignalNameColumnFamily.deleteExisting(this.subscriptionKeyAndSignalName);
    }

    @Override
    public boolean exists(SignalSubscriptionRecord subscription) {
        this.wrapSubscriptionKeys(subscription);
        return this.signalNameAndSubscriptionKeyColumnFamily.exists(this.signalNameAndSubscriptionKey);
    }

    @Override
    public void visitBySignalName(DirectBuffer signalName, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.signalName.wrapBuffer(signalName);
        this.signalNameAndSubscriptionKeyColumnFamily.whileEqualPrefix((DbKey)this.signalName, (key, value) -> visitor.visit((SignalSubscription)value));
    }

    @Override
    public void visitStartEventSubscriptionsByProcessDefinitionKey(long processDefinitionKey, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKey.wrapLong(processDefinitionKey);
        this.visitSubscriptions(visitor);
    }

    @Override
    public void visitByElementInstanceKey(long elementInstanceKey, SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKey.wrapLong(elementInstanceKey);
        this.visitSubscriptions(visitor);
    }

    private void visitSubscriptions(SignalSubscriptionState.SignalSubscriptionVisitor visitor) {
        this.subscriptionKeyAndSignalNameColumnFamily.whileEqualPrefix((DbKey)this.subscriptionKey, (key, value) -> {
            SignalSubscription subscription = this.signalNameAndSubscriptionKeyColumnFamily.get(this.signalNameAndSubscriptionKey);
            if (subscription != null) {
                visitor.visit(subscription);
            }
        });
    }

    private void wrapSubscriptionKeys(SignalSubscriptionRecord subscription) {
        long key = subscription.getSubscriptionKey();
        this.wrapSubscriptionKeys(key, subscription.getSignalNameBuffer());
    }

    private void wrapSubscriptionKeys(long key, DirectBuffer signalName) {
        this.subscriptionKey.wrapLong(key);
        this.signalName.wrapBuffer(signalName);
    }
}

