/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.feel.impl.Loggers;
import io.camunda.zeebe.feel.impl.MessagePackContext;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.Serializable;
import org.agrona.DirectBuffer;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.valuemapper.CustomValueMapper;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.math.BigDecimal$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005%4A!\u0003\u0006\u0001+!)a\u0005\u0001C\u0001O!9!\u0006\u0001b\u0001\n\u0013Y\u0003B\u0002\u001b\u0001A\u0003%A\u0006C\u00036\u0001\u0011\u0005c\u0007C\u0003K\u0001\u0011%1\nC\u0003U\u0001\u0011%Q\u000bC\u0003W\u0001\u0011%q\u000bC\u0003c\u0001\u0011\u00053M\u0001\fNKN\u001c\u0018mZ3QC\u000e\\g+\u00197vK6\u000b\u0007\u000f]3s\u0015\tYA\"\u0001\u0003j[Bd'BA\u0007\u000f\u0003\u00111W-\u001a7\u000b\u0005=\u0001\u0012!\u0002>fK\n,'BA\t\u0013\u0003\u001d\u0019\u0017-\\;oI\u0006T\u0011aE\u0001\u0003S>\u001c\u0001aE\u0002\u0001-q\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0007CA\u000f%\u001b\u0005q\"BA\u0010!\u0003-1\u0018\r\\;f[\u0006\u0004\b/\u001a:\u000b\u00055\t#BA\t#\u0015\u0005\u0019\u0013aA8sO&\u0011QE\b\u0002\u0012\u0007V\u001cHo\\7WC2,X-T1qa\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u000b\u0003\u0019\u0011X-\u00193feV\tA\u0006\u0005\u0002.e5\taF\u0003\u00020a\u0005!1\u000f]3d\u0015\t\td\"A\u0004ng\u001e\u0004\u0018mY6\n\u0005Mr#!D'tOB\u000b7m\u001b*fC\u0012,'/A\u0004sK\u0006$WM\u001d\u0011\u0002\u000bQ|g+\u00197\u0015\u0007]\u0002U\tE\u0002\u0018qiJ!!\u000f\r\u0003\r=\u0003H/[8o!\tYd(D\u0001=\u0015\ti\u0004%\u0001\u0006ts:$\u0018\r\u001f;sK\u0016L!a\u0010\u001f\u0003\u0007Y\u000bG\u000eC\u0003B\t\u0001\u0007!)A\u0001y!\t92)\u0003\u0002E1\t\u0019\u0011I\\=\t\u000b\u0019#\u0001\u0019A$\u0002!%tg.\u001a:WC2,X-T1qa\u0016\u0014\b\u0003B\fI\u0005jJ!!\u0013\r\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u0004:fC\u0012lUm]:bO\u0016\u0004\u0016mY6\u0015\u0005ib\u0005\"B'\u0006\u0001\u0004q\u0015aC7fgN\fw-\u001a)bG.\u0004\"a\u0014*\u000e\u0003AS!!\u0015\u0012\u0002\r\u0005<'o\u001c8b\u0013\t\u0019\u0006K\u0001\u0007ESJ,7\r\u001e\"vM\u001a,'/\u0001\u0005sK\u0006$g*\u001a=u)\u0005Q\u0014\u0001\u0002:fC\u0012$2A\u000f-^\u0011\u0015Iv\u00011\u0001[\u0003\u0015!xn[3o!\ti3,\u0003\u0002]]\taQj]4QC\u000e\\Gk\\6f]\")al\u0002a\u0001?\u00061qN\u001a4tKR\u0004\"a\u00061\n\u0005\u0005D\"aA%oi\u0006IQO\u001c9bG.4\u0016\r\u001c\u000b\u0004I\u0016<\u0007cA\f9\u0005\")a\r\u0003a\u0001u\u0005)a/\u00197vK\")a\t\u0003a\u0001QB!q\u0003\u0013\u001eC\u0001")
public class MessagePackValueMapper
implements CustomValueMapper {
    private final MsgPackReader reader;
    private int priority;

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public void org$camunda$feel$valuemapper$CustomValueMapper$_setter_$priority_$eq(int x$1) {
        this.priority = x$1;
    }

    private MsgPackReader reader() {
        return this.reader;
    }

    @Override
    public Option<Val> toVal(Object x, Function1<Object, Val> innerValueMapper) {
        Object object = x;
        if (object instanceof DirectBuffer) {
            DirectBuffer directBuffer = (DirectBuffer)object;
            Val value = this.readMessagePack(directBuffer);
            return new Some<Val>(value);
        }
        return None$.MODULE$;
    }

    private Val readMessagePack(DirectBuffer messagePack) {
        this.reader().wrap(messagePack, 0, messagePack.capacity());
        return this.readNext();
    }

    private Val readNext() {
        int offset = this.reader().getOffset();
        MsgPackToken token = this.reader().readToken();
        return this.read(token, offset);
    }

    private Val read(MsgPackToken token, int offset) {
        MsgPackType msgPackType = token.getType();
        if (((Object)((Object)MsgPackType.NIL)).equals((Object)msgPackType)) {
            return ValNull$.MODULE$;
        }
        if (((Object)((Object)MsgPackType.BOOLEAN)).equals((Object)msgPackType)) {
            return new ValBoolean(token.getBooleanValue());
        }
        if (((Object)((Object)MsgPackType.INTEGER)).equals((Object)msgPackType)) {
            return new ValNumber(BigDecimal$.MODULE$.long2bigDecimal(token.getIntegerValue()));
        }
        if (((Object)((Object)MsgPackType.FLOAT)).equals((Object)msgPackType)) {
            return new ValNumber(BigDecimal$.MODULE$.double2bigDecimal(token.getFloatValue()));
        }
        if (((Object)((Object)MsgPackType.STRING)).equals((Object)msgPackType)) {
            String asString = BufferUtil.bufferAsString(token.getValueBuffer());
            return new ValString(asString);
        }
        if (((Object)((Object)MsgPackType.ARRAY)).equals((Object)msgPackType)) {
            List<Val> items = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), token.getSize()).map((Function1<Object, Val> & Serializable)x$1 -> this.readNext()).toList();
            return new ValList(items);
        }
        if (((Object)((Object)MsgPackType.MAP)).equals((Object)msgPackType)) {
            MessagePackContext context = new MessagePackContext(this.reader(), offset, token.getSize());
            return new ValContext(context);
        }
        Loggers.LOGGER.warn("No MessagePack to FEEL transformation for type '{}'. Using 'null' instead.", (Object)msgPackType);
        return ValNull$.MODULE$;
    }

    @Override
    public Option<Object> unpackVal(Val value, Function1<Val, Object> innerValueMapper) {
        return new Some<Object>(value);
    }

    public MessagePackValueMapper() {
        CustomValueMapper.$init$(this);
        this.reader = new MsgPackReader();
        Statics.releaseFence();
    }
}

