/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.log;

import io.camunda.zeebe.logstreams.impl.log.SequencedBatch;
import io.camunda.zeebe.logstreams.impl.log.SequencerMetrics;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.logstreams.log.LogStreamWriter;
import io.camunda.zeebe.scheduler.ActorCondition;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.util.Either;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Sequencer
implements LogStreamWriter,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Sequencer.class);
    private final int maxFragmentSize;
    private volatile long position;
    private volatile boolean isClosed = false;
    private volatile ActorCondition consumer;
    private final Queue<SequencedBatch> queue = new ArrayBlockingQueue<SequencedBatch>(128);
    private final ReentrantLock lock = new ReentrantLock();
    private final SequencerMetrics metrics;

    Sequencer(long initialPosition, int maxFragmentSize, SequencerMetrics metrics) {
        LOG.trace("Starting new sequencer at position {}", (Object)initialPosition);
        this.position = initialPosition;
        this.maxFragmentSize = maxFragmentSize;
        this.metrics = Objects.requireNonNull(metrics, "must specify metrics");
    }

    @Override
    public boolean canWriteEvents(int eventCount, int batchSize) {
        int framedMessageLength = batchSize + eventCount * 20 + 8;
        return framedMessageLength <= this.maxFragmentSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Either<LogStreamWriter.WriteFailure, Long> tryWrite(List<LogAppendEntry> appendEntries, long sourcePosition) {
        boolean isEnqueued;
        long currentPosition;
        if (this.isClosed) {
            LOG.warn("Rejecting write of {}, sequencer is closed", (Object)appendEntries);
            return Either.left(LogStreamWriter.WriteFailure.CLOSED);
        }
        for (LogAppendEntry entry : appendEntries) {
            if (this.isEntryValid(entry)) continue;
            LOG.warn("Reject write of invalid entry {}", (Object)entry);
            return Either.left(LogStreamWriter.WriteFailure.INVALID_ARGUMENT);
        }
        int batchSize = appendEntries.size();
        if (batchSize == 0) {
            return Either.left(LogStreamWriter.WriteFailure.INVALID_ARGUMENT);
        }
        this.lock.lock();
        try {
            currentPosition = this.position;
            SequencedBatch sequencedBatch = new SequencedBatch(ActorClock.currentTimeMillis(), currentPosition, sourcePosition, appendEntries);
            isEnqueued = this.queue.offer(sequencedBatch);
            if (isEnqueued) {
                this.metrics.observeBatchLengthBytes(sequencedBatch.length());
                this.position = currentPosition + (long)batchSize;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.consumer != null) {
            this.consumer.signal();
        }
        this.metrics.setQueueSize(this.queue.size());
        if (isEnqueued) {
            this.metrics.observeBatchSize(batchSize);
            return Either.right(currentPosition + (long)batchSize - 1L);
        }
        LOG.trace("Rejecting write of {}, sequencer queue is full", (Object)appendEntries);
        return Either.left(LogStreamWriter.WriteFailure.FULL);
    }

    SequencedBatch tryRead() {
        return this.queue.poll();
    }

    @Override
    public void close() {
        LOG.info("Closing sequencer for writing");
        this.isClosed = true;
    }

    void registerConsumer(ActorCondition consumer) {
        this.consumer = consumer;
    }

    private boolean isEntryValid(LogAppendEntry entry) {
        return entry.recordValue() != null && entry.recordValue().getLength() > 0 && entry.recordMetadata() != null && entry.recordMetadata().getLength() > 0;
    }
}

