/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class StringValue
extends BaseValue {
    public static final String EMPTY_STRING = "";
    private final MutableDirectBuffer bytes = new UnsafeBuffer(0L, 0);
    private int length;

    public StringValue() {
        this(EMPTY_STRING);
    }

    public StringValue(String string) {
        this(BufferUtil.wrapString(string));
    }

    public StringValue(DirectBuffer buffer) {
        this(buffer, 0, buffer.capacity());
    }

    public StringValue(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    @Override
    public void reset() {
        this.bytes.wrap(0L, 0);
        this.length = 0;
    }

    public void wrap(byte[] bytes) {
        this.bytes.wrap(bytes);
        this.length = bytes.length;
    }

    public void wrap(DirectBuffer buff) {
        this.wrap(buff, 0, buff.capacity());
    }

    public void wrap(DirectBuffer buff, int offset, int length) {
        if (length == 0) {
            this.bytes.wrap(0L, 0);
        } else {
            this.bytes.wrap(buff, offset, length);
        }
        this.length = length;
    }

    public void wrap(StringValue anotherString) {
        this.wrap(anotherString.getValue());
    }

    public int getLength() {
        return this.length;
    }

    public DirectBuffer getValue() {
        return this.bytes;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append("\"");
        builder.append(this.toString());
        builder.append("\"");
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeString(this.bytes);
    }

    @Override
    public void read(MsgPackReader reader) {
        DirectBuffer buffer = reader.getBuffer();
        int stringLength = reader.readStringLength();
        int offset = reader.getOffset();
        reader.skipBytes(stringLength);
        this.wrap(buffer, offset, stringLength);
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedStringLength(this.length);
    }

    @Override
    public String toString() {
        return this.bytes.getStringWithoutLengthUtf8(0, this.length);
    }

    public int hashCode() {
        return Objects.hash(this.bytes, this.getLength());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringValue)) {
            return false;
        }
        StringValue that = (StringValue)o;
        return this.getLength() == that.getLength() && Objects.equals(this.bytes, that.bytes);
    }
}

