/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.process.test.engine.InMemoryLogStorage;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EngineStateMonitor
implements LogStorage.CommitListener {
    private static final Logger LOG = LoggerFactory.getLogger(EngineStateMonitor.class);
    private static final int GRACE_PERIOD_MS = 50;
    private static final int NOTIFICATION_THRESHOLD = 2;
    private static final Timer TIMER = new Timer();
    private final List<Runnable> idleCallbacks = new ArrayList<Runnable>();
    private final List<Runnable> processingCallbacks = new ArrayList<Runnable>();
    private final StreamProcessor streamProcessor;
    private volatile TimerTask stateNotifier;

    EngineStateMonitor(InMemoryLogStorage logStorage, StreamProcessor streamProcessor) {
        logStorage.addCommitListener(this);
        this.streamProcessor = streamProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnIdleCallback(Runnable callback) {
        List<Runnable> list = this.idleCallbacks;
        synchronized (list) {
            this.idleCallbacks.add(callback);
        }
        this.scheduleStateNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnProcessingCallback(Runnable callback) {
        List<Runnable> list = this.processingCallbacks;
        synchronized (list) {
            this.processingCallbacks.add(callback);
        }
        this.scheduleStateNotification();
    }

    private synchronized void scheduleStateNotification() {
        if (this.stateNotifier != null) {
            this.stateNotifier.cancel();
            TIMER.purge();
        }
        this.stateNotifier = this.createStateNotifier();
        TIMER.scheduleAtFixedRate(this.stateNotifier, 50L, 50L);
    }

    private boolean isInIdleState() {
        try {
            return this.streamProcessor.hasProcessingReachedTheEnd().join();
        }
        catch (Exception e) {
            LOG.debug("Exception occurred while checking idle state", e);
            return this.streamProcessor.isActorClosed();
        }
    }

    @Override
    public void onCommit() {
        this.notifyProcessingCallbacks();
        if (!this.idleCallbacks.isEmpty() || !this.processingCallbacks.isEmpty()) {
            this.scheduleStateNotification();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIdleCallbacks() {
        List<Runnable> list = this.idleCallbacks;
        synchronized (list) {
            this.idleCallbacks.forEach(Runnable::run);
            this.idleCallbacks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyProcessingCallbacks() {
        List<Runnable> list = this.processingCallbacks;
        synchronized (list) {
            this.processingCallbacks.forEach(Runnable::run);
            this.processingCallbacks.clear();
        }
    }

    private TimerTask createStateNotifier() {
        return new TimerTask(){
            private int idleStateReachedCounter = 0;

            @Override
            public void run() {
                if (!EngineStateMonitor.this.idleCallbacks.isEmpty() || !EngineStateMonitor.this.processingCallbacks.isEmpty()) {
                    if (EngineStateMonitor.this.isInIdleState()) {
                        ++this.idleStateReachedCounter;
                        if (this.idleStateReachedCounter >= 2) {
                            EngineStateMonitor.this.notifyIdleCallbacks();
                        }
                    } else {
                        this.idleStateReachedCounter = 0;
                        EngineStateMonitor.this.notifyProcessingCallbacks();
                    }
                }
                if (EngineStateMonitor.this.idleCallbacks.isEmpty() && EngineStateMonitor.this.processingCallbacks.isEmpty()) {
                    this.cancel();
                }
            }
        };
    }
}

