/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.auth.impl.Authorization;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class AuthInfo
extends UnpackedObject {
    private final EnumProperty<AuthDataFormat> formatProp = new EnumProperty<AuthDataFormat>("format", AuthDataFormat.class, AuthDataFormat.UNKNOWN);
    private final StringProperty authDataProp = new StringProperty("authData", "");

    public AuthInfo() {
        super(2);
        this.declareProperty(this.formatProp).declareProperty(this.authDataProp);
    }

    public AuthDataFormat getFormat() {
        return this.formatProp.getValue();
    }

    public AuthInfo setFormatProp(AuthDataFormat format) {
        this.formatProp.setValue(format);
        return this;
    }

    public DirectBuffer getAuthDataBuffer() {
        return this.authDataProp.getValue();
    }

    public String getAuthData() {
        return BufferUtil.bufferAsString(this.authDataProp.getValue());
    }

    public AuthInfo setAuthData(String authData) {
        this.authDataProp.setValue(authData);
        return this;
    }

    public void wrap(AuthInfo authInfo) {
        this.formatProp.setValue(authInfo.getFormat());
        this.authDataProp.setValue(authInfo.getAuthData());
    }

    @Override
    public void reset() {
        this.formatProp.setValue(AuthDataFormat.UNKNOWN);
        this.authDataProp.setValue("");
    }

    public DirectBuffer toDirectBuffer() {
        byte[] bytes = new byte[this.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.write(buffer, 0);
        return buffer;
    }

    public Map<String, Object> toDecodedMap() {
        switch (this.getFormat()) {
            case JWT: {
                String jwtToken = this.getAuthData();
                return Authorization.jwtDecoder(jwtToken).withClaim("authorized_tenants").decode();
            }
        }
        return Map.of("authorized_tenants", List.of("<default>"));
    }

    @Override
    public String toString() {
        Object data = this.getAuthData();
        data = ((String)data).isEmpty() ? "" : "." + (String)data;
        return this.formatProp.getValue().toString() + (String)data;
    }

    public static enum AuthDataFormat {
        UNKNOWN(0),
        JWT(1);

        public final short id;

        private AuthDataFormat(short id) {
            this.id = id;
        }
    }
}

