/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.management.BackupListResponseDecoder;
import io.camunda.zeebe.protocol.management.BackupListResponseEncoder;
import io.camunda.zeebe.protocol.management.BackupStatusCode;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;

public class BackupListResponse
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final BackupListResponseEncoder bodyEncoder = new BackupListResponseEncoder();
    private final BackupListResponseDecoder bodyDecoder = new BackupListResponseDecoder();
    private List<InternalBackupStatus> internalBackups;

    public BackupListResponse() {
    }

    public BackupListResponse(List<BackupStatus> statuses) {
        this.internalBackups = statuses.stream().map(InternalBackupStatus::new).toList();
    }

    public BackupListResponse(DirectBuffer buffer, int offset, int length) {
        this.wrap(buffer, offset, length);
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.internalBackups = new ArrayList<InternalBackupStatus>();
        for (BackupListResponseDecoder.BackupsDecoder backupsDecoder : this.bodyDecoder.backups()) {
            byte[] encodedFailureReason = new byte[backupsDecoder.failureReasonLength()];
            backupsDecoder.getFailureReason(encodedFailureReason, 0, encodedFailureReason.length);
            byte[] encodedCreatedAt = new byte[backupsDecoder.createdAtLength()];
            backupsDecoder.getCreatedAt(encodedCreatedAt, 0, encodedCreatedAt.length);
            byte[] encodedBrokerVersion = new byte[backupsDecoder.brokerVersionLength()];
            backupsDecoder.getBrokerVersion(encodedBrokerVersion, 0, encodedBrokerVersion.length);
            this.internalBackups.add(new InternalBackupStatus(backupsDecoder.backupId(), backupsDecoder.partitionId(), backupsDecoder.status(), encodedFailureReason, encodedBrokerVersion, encodedCreatedAt));
        }
    }

    @Override
    public int getLength() {
        int backupsLength = this.internalBackups.stream().map(backup -> BackupListResponseEncoder.BackupsEncoder.sbeBlockLength() + BackupListResponseEncoder.BackupsEncoder.failureReasonHeaderLength() + backup.encodedFailureReason.length + BackupListResponseEncoder.BackupsEncoder.brokerVersionHeaderLength() + backup.encodedBrokerVersion.length + BackupListResponseEncoder.BackupsEncoder.createdAtHeaderLength() + backup.encodedCreatedAt.length).reduce(Integer::sum).orElse(0);
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + 8 + backupsLength;
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder);
        BackupListResponseEncoder.BackupsEncoder backupsEncoder = this.bodyEncoder.backupsCount(this.internalBackups.size());
        this.internalBackups.forEach(backup -> backupsEncoder.next().backupId(backup.status.backupId).partitionId(backup.status.partitionId).status(backup.status.status).putFailureReason(backup.encodedFailureReason, 0, backup.encodedFailureReason.length).putCreatedAt(backup.encodedCreatedAt, 0, backup.encodedCreatedAt.length).putBrokerVersion(backup.encodedBrokerVersion, 0, backup.encodedBrokerVersion.length));
    }

    public List<BackupStatus> getBackups() {
        return this.internalBackups.stream().map(s2 -> s2.status).toList();
    }

    private static final class InternalBackupStatus {
        private final BackupStatus status;
        private final byte[] encodedFailureReason;
        private final byte[] encodedBrokerVersion;
        private final byte[] encodedCreatedAt;

        InternalBackupStatus(BackupStatus status) {
            this.status = status;
            this.encodedFailureReason = InternalBackupStatus.encodeString(status.failureReason(), BackupListResponseEncoder.BackupsEncoder.failureReasonCharacterEncoding());
            this.encodedBrokerVersion = InternalBackupStatus.encodeString(status.brokerVersion(), BackupListResponseEncoder.BackupsEncoder.brokerVersionCharacterEncoding());
            this.encodedCreatedAt = InternalBackupStatus.encodeString(status.createdAt(), BackupListResponseEncoder.BackupsEncoder.createdAtCharacterEncoding());
        }

        InternalBackupStatus(long backupId, int partitionId, BackupStatusCode statusCode, byte[] encodedFailureReason, byte[] encodedBrokerVersion, byte[] encodedCreatedAt) {
            this.status = new BackupStatus(backupId, partitionId, statusCode, InternalBackupStatus.decodeString(encodedFailureReason, BackupListResponseDecoder.BackupsDecoder.failureReasonCharacterEncoding()), InternalBackupStatus.decodeString(encodedBrokerVersion, BackupListResponseDecoder.BackupsDecoder.brokerVersionCharacterEncoding()), InternalBackupStatus.decodeString(encodedCreatedAt, BackupListResponseDecoder.BackupsDecoder.createdAtCharacterEncoding()));
            this.encodedCreatedAt = encodedCreatedAt;
            this.encodedBrokerVersion = encodedBrokerVersion;
            this.encodedFailureReason = encodedFailureReason;
        }

        private static byte[] encodeString(String value, String charsetName) {
            try {
                return null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        private static String decodeString(byte[] value, String charsetName) {
            try {
                return new String(value, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public record BackupStatus(long backupId, int partitionId, BackupStatusCode status, String failureReason, String brokerVersion, String createdAt) {
    }
}

