/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.ErrorCode;
import io.camunda.zeebe.protocol.record.ErrorResponseDecoder;
import io.camunda.zeebe.protocol.record.ErrorResponseEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ErrorResponse
implements BufferWriter,
BufferReader {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ErrorResponseEncoder bodyEncoder = new ErrorResponseEncoder();
    private final ErrorResponseDecoder bodyDecoder = new ErrorResponseDecoder();
    private final DirectBuffer errorData = new UnsafeBuffer();
    private ErrorCode errorCode;

    public ErrorResponse() {
        this.reset();
    }

    public ErrorResponse reset() {
        this.errorCode = ErrorCode.NULL_VAL;
        this.errorData.wrap(0L, 0);
        return this;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public ErrorResponse setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    public DirectBuffer getErrorData() {
        return this.errorData;
    }

    public ErrorResponse setErrorData(DirectBuffer errorData) {
        this.errorData.wrap(errorData, 0, errorData.capacity());
        return this;
    }

    public boolean tryWrap(DirectBuffer buffer) {
        return this.tryWrap(buffer, 0, buffer.capacity());
    }

    public boolean tryWrap(DirectBuffer buffer, int offset, int length) {
        this.headerDecoder.wrap(buffer, offset);
        return this.headerDecoder.schemaId() == this.bodyDecoder.sbeSchemaId() && this.headerDecoder.templateId() == this.bodyDecoder.sbeTemplateId();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        int frameEnd = offset + length;
        this.headerDecoder.wrap(buffer, offset);
        this.bodyDecoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.errorCode = this.bodyDecoder.errorCode();
        offset += this.bodyDecoder.sbeBlockLength();
        int errorDataLength = this.bodyDecoder.errorDataLength();
        offset += ErrorResponseDecoder.errorDataHeaderLength();
        if (errorDataLength > 0) {
            this.errorData.wrap(buffer, offset, errorDataLength);
            offset += errorDataLength;
        }
        this.bodyDecoder.limit(offset);
        assert (this.bodyDecoder.limit() == frameEnd) : "Decoder read only to position " + this.bodyDecoder.limit() + " but expected " + frameEnd + " as final position";
    }

    @Override
    public int getLength() {
        return 9 + ErrorResponseEncoder.errorDataHeaderLength() + this.errorData.capacity();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.bodyEncoder.sbeBlockLength()).templateId(this.bodyEncoder.sbeTemplateId()).schemaId(this.bodyEncoder.sbeSchemaId()).version(this.bodyEncoder.sbeSchemaVersion());
        this.bodyEncoder.wrap(buffer, offset += this.headerEncoder.encodedLength()).errorCode(this.errorCode).putErrorData(this.errorData, 0, this.errorData.capacity());
    }

    public byte[] toBytes() {
        byte[] bytes = new byte[this.getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        this.write(buffer, 0);
        return bytes;
    }

    public String toString() {
        return "ErrorResponse{errorCode=" + this.errorCode + "}";
    }
}

