/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.record.ExecuteQueryRequestDecoder;
import io.camunda.zeebe.protocol.record.ExecuteQueryRequestEncoder;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class ExecuteQueryRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final ExecuteQueryRequestEncoder bodyEncoder = new ExecuteQueryRequestEncoder();
    private final ExecuteQueryRequestDecoder bodyDecoder = new ExecuteQueryRequestDecoder();
    private int partitionId;
    private long key;
    private ValueType valueType;

    public ExecuteQueryRequest() {
        this.reset();
    }

    public ExecuteQueryRequest reset() {
        this.partitionId = ExecuteQueryRequestEncoder.partitionIdNullValue();
        this.key = ExecuteQueryRequestEncoder.keyNullValue();
        this.valueType = ValueType.NULL_VAL;
        return this;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ExecuteQueryRequest setPartitionId(int partitionId) {
        this.partitionId = partitionId;
        return this;
    }

    public long getKey() {
        return this.key;
    }

    public ExecuteQueryRequest setKey(long key) {
        this.key = key;
        return this;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public ExecuteQueryRequest setValueType(ValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    @Override
    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).partitionId(this.partitionId).key(this.key).valueType(this.valueType);
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.partitionId = this.bodyDecoder.partitionId();
        this.key = this.bodyDecoder.key();
        this.valueType = this.bodyDecoder.valueType();
    }
}

