/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record;

import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.impl.record.VersionInfo;
import io.camunda.zeebe.protocol.record.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.RecordMetadataDecoder;
import io.camunda.zeebe.protocol.record.RecordMetadataEncoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.VersionUtil;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class RecordMetadata
implements BufferWriter,
BufferReader {
    public static final int BLOCK_LENGTH = 40;
    public static final int DEFAULT_RECORD_VERSION = 1;
    public static final VersionInfo CURRENT_BROKER_VERSION = VersionInfo.parse(VersionUtil.getVersion());
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final RecordMetadataEncoder encoder = new RecordMetadataEncoder();
    private final RecordMetadataDecoder decoder = new RecordMetadataDecoder();
    private RecordType recordType = RecordType.NULL_VAL;
    private ValueType valueType = ValueType.NULL_VAL;
    private Intent intent = null;
    private long requestId;
    private short intentValue = (short)255;
    private int requestStreamId;
    private final AuthInfo authorization = new AuthInfo();
    private RejectionType rejectionType;
    private final UnsafeBuffer rejectionReason = new UnsafeBuffer(0L, 0);
    private int protocolVersion = 4;
    private VersionInfo brokerVersion = CURRENT_BROKER_VERSION;
    private int recordVersion = 1;

    public RecordMetadata() {
        this.reset();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.reset();
        this.headerDecoder.wrap(buffer, offset);
        this.decoder.wrap(buffer, offset += this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        this.recordType = this.decoder.recordType();
        this.requestStreamId = this.decoder.requestStreamId();
        this.requestId = this.decoder.requestId();
        this.protocolVersion = this.decoder.protocolVersion();
        this.valueType = this.decoder.valueType();
        this.intent = Intent.fromProtocolValue(this.valueType, this.decoder.intent());
        this.rejectionType = this.decoder.rejectionType();
        this.brokerVersion = Optional.ofNullable(this.decoder.brokerVersion()).map(versionDecoder -> new VersionInfo(versionDecoder.majorVersion(), versionDecoder.minorVersion(), versionDecoder.patchVersion())).orElse(VersionInfo.UNKNOWN);
        int decodedRecordVersion = this.decoder.recordVersion();
        this.recordVersion = decodedRecordVersion == 0 || decodedRecordVersion == RecordMetadataDecoder.recordVersionNullValue() ? 1 : decodedRecordVersion;
        int rejectionReasonLength = this.decoder.rejectionReasonLength();
        if (rejectionReasonLength > 0) {
            this.decoder.wrapRejectionReason(this.rejectionReason);
        } else {
            this.decoder.skipRejectionReason();
        }
        int authorizationLength = this.decoder.authorizationLength();
        if (authorizationLength > 0) {
            UnsafeBuffer authBuffer = new UnsafeBuffer();
            this.decoder.wrapAuthorization(authBuffer);
            this.authorization.wrap(authBuffer);
        } else {
            this.decoder.skipAuthorization();
        }
    }

    @Override
    public int getLength() {
        return 40 + RecordMetadataEncoder.rejectionReasonHeaderLength() + this.rejectionReason.capacity() + RecordMetadataEncoder.authorizationHeaderLength() + this.authorization.getLength();
    }

    @Override
    public void write(MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset);
        this.headerEncoder.blockLength(this.encoder.sbeBlockLength()).templateId(this.encoder.sbeTemplateId()).schemaId(this.encoder.sbeSchemaId()).version(this.encoder.sbeSchemaVersion());
        this.encoder.wrap(buffer, offset += this.headerEncoder.encodedLength());
        this.encoder.recordType(this.recordType).requestStreamId(this.requestStreamId).requestId(this.requestId).protocolVersion(this.protocolVersion).valueType(this.valueType).intent(this.intentValue).rejectionType(this.rejectionType).recordVersion(this.recordVersion);
        this.encoder.brokerVersion().majorVersion(this.brokerVersion.getMajorVersion()).minorVersion(this.brokerVersion.getMinorVersion()).patchVersion(this.brokerVersion.getPatchVersion());
        this.encoder.putRejectionReason(this.rejectionReason, 0, this.rejectionReason.capacity());
        this.encoder.putAuthorization(this.authorization.toDirectBuffer(), 0, this.authorization.getLength());
    }

    public long getRequestId() {
        return this.requestId;
    }

    public RecordMetadata requestId(long requestId) {
        this.requestId = requestId;
        return this;
    }

    public int getRequestStreamId() {
        return this.requestStreamId;
    }

    public RecordMetadata requestStreamId(int requestStreamId) {
        this.requestStreamId = requestStreamId;
        return this;
    }

    public RecordMetadata protocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
        return this;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public RecordMetadata valueType(ValueType eventType) {
        this.valueType = eventType;
        return this;
    }

    public RecordMetadata intent(Intent intent) {
        this.intent = intent;
        this.intentValue = intent.value();
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public RecordMetadata recordType(RecordType recordType) {
        this.recordType = recordType;
        return this;
    }

    public RecordType getRecordType() {
        return this.recordType;
    }

    public RecordMetadata rejectionType(RejectionType rejectionType) {
        this.rejectionType = rejectionType;
        return this;
    }

    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    public RecordMetadata rejectionReason(String rejectionReason) {
        byte[] bytes = rejectionReason.getBytes(StandardCharsets.UTF_8);
        this.rejectionReason.wrap(bytes);
        return this;
    }

    public RecordMetadata rejectionReason(DirectBuffer buffer) {
        this.rejectionReason.wrap(buffer);
        return this;
    }

    public String getRejectionReason() {
        return BufferUtil.bufferAsString(this.rejectionReason);
    }

    public RecordMetadata authorization(AuthInfo authorization) {
        this.authorization.wrap(authorization);
        return this;
    }

    public RecordMetadata authorization(DirectBuffer buffer) {
        this.authorization.wrap(buffer);
        return this;
    }

    public AuthInfo getAuthorization() {
        return this.authorization;
    }

    public RecordMetadata brokerVersion(VersionInfo brokerVersion) {
        this.brokerVersion = brokerVersion;
        return this;
    }

    public VersionInfo getBrokerVersion() {
        return this.brokerVersion;
    }

    public RecordMetadata recordVersion(int recordVersion) {
        this.recordVersion = recordVersion;
        return this;
    }

    public int getRecordVersion() {
        return this.recordVersion;
    }

    public RecordMetadata reset() {
        this.recordType = RecordType.NULL_VAL;
        this.requestId = RecordMetadataEncoder.requestIdNullValue();
        this.requestStreamId = RecordMetadataEncoder.requestStreamIdNullValue();
        this.protocolVersion = 4;
        this.valueType = ValueType.NULL_VAL;
        this.intentValue = (short)255;
        this.intent = null;
        this.rejectionType = RejectionType.NULL_VAL;
        this.rejectionReason.wrap(0L, 0);
        this.authorization.reset();
        this.brokerVersion = CURRENT_BROKER_VERSION;
        this.recordVersion = 1;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestId, this.valueType, this.recordType, this.intentValue, this.requestStreamId, this.rejectionType, this.rejectionReason, this.authorization, this.protocolVersion, this.brokerVersion, this.recordVersion});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordMetadata that = (RecordMetadata)o;
        return this.requestId == that.requestId && this.intentValue == that.intentValue && this.requestStreamId == that.requestStreamId && this.protocolVersion == that.protocolVersion && this.valueType == that.valueType && this.recordType == that.recordType && this.rejectionType == that.rejectionType && this.rejectionReason.equals(that.rejectionReason) && this.authorization.equals(that.authorization) && this.brokerVersion.equals(that.brokerVersion) && this.recordVersion == that.recordVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RecordMetadata{recordType=" + this.recordType + ", valueType=" + this.valueType + ", intent=" + this.intent);
        if (!this.rejectionType.equals((Object)RejectionType.NULL_VAL)) {
            builder.append(", rejectionType=").append((Object)this.rejectionType);
        }
        if (this.rejectionReason.capacity() > 0) {
            builder.append(", rejectionReason=").append(BufferUtil.bufferAsString(this.rejectionReason));
        }
        if (!this.authorization.isEmpty()) {
            builder.append(", authorization=").append(this.authorization);
        }
        builder.append('}');
        return builder.toString();
    }
}

