/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessInstanceRecord
extends UnifiedRecordValue
implements ProcessInstanceRecordValue {
    public static final String PROP_PROCESS_BPMN_PROCESS_ID = "bpmnProcessId";
    public static final String PROP_PROCESS_INSTANCE_KEY = "processInstanceKey";
    public static final String PROP_PROCESS_ELEMENT_ID = "elementId";
    public static final String PROP_PROCESS_VERSION = "version";
    public static final String PROP_PROCESS_KEY = "processDefinitionKey";
    public static final String PROP_PROCESS_BPMN_TYPE = "bpmnElementType";
    public static final String PROP_PROCESS_SCOPE_KEY = "flowScopeKey";
    public static final String PROP_PROCESS_EVENT_TYPE = "bpmnEventType";
    public static final String PROP_TENANT_ID = "tenantId";
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final IntegerProperty versionProp = new IntegerProperty("version", -1);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final LongProperty flowScopeKeyProp = new LongProperty("flowScopeKey", -1L);
    private final EnumProperty<BpmnElementType> bpmnElementTypeProp = new EnumProperty<BpmnElementType>("bpmnElementType", BpmnElementType.class, BpmnElementType.UNSPECIFIED);
    private final EnumProperty<BpmnEventType> bpmnEventTypeProp = new EnumProperty<BpmnEventType>("bpmnEventType", BpmnEventType.class, BpmnEventType.UNSPECIFIED);
    private final LongProperty parentProcessInstanceKeyProp = new LongProperty("parentProcessInstanceKey", -1L);
    private final LongProperty parentElementInstanceKeyProp = new LongProperty("parentElementInstanceKey", -1L);

    public ProcessInstanceRecord() {
        super(11);
        this.declareProperty(this.bpmnElementTypeProp).declareProperty(this.elementIdProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.versionProp).declareProperty(this.processDefinitionKeyProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.flowScopeKeyProp).declareProperty(this.bpmnEventTypeProp).declareProperty(this.parentProcessInstanceKeyProp).declareProperty(this.parentElementInstanceKeyProp).declareProperty(this.tenantIdProp);
    }

    public void wrap(ProcessInstanceRecord record) {
        this.elementIdProp.setValue(record.getElementIdBuffer());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.flowScopeKeyProp.setValue(record.getFlowScopeKey());
        this.versionProp.setValue(record.getVersion());
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.bpmnElementTypeProp.setValue(record.getBpmnElementType());
        this.bpmnEventTypeProp.setValue(record.getBpmnEventType());
        this.parentProcessInstanceKeyProp.setValue(record.getParentProcessInstanceKey());
        this.parentElementInstanceKeyProp.setValue(record.getParentElementInstanceKey());
        this.tenantIdProp.setValue(record.getTenantId());
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    public ProcessInstanceRecord setBpmnProcessId(DirectBuffer directBuffer, int offset, int length) {
        this.bpmnProcessIdProp.setValue(directBuffer, offset, length);
        return this;
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    @Override
    public int getVersion() {
        return this.versionProp.getValue();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public ProcessInstanceRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProp.setValue(processInstanceKey);
        return this;
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.elementIdProp.getValue());
    }

    @Override
    public long getFlowScopeKey() {
        return this.flowScopeKeyProp.getValue();
    }

    @Override
    public BpmnElementType getBpmnElementType() {
        return this.bpmnElementTypeProp.getValue();
    }

    @Override
    public long getParentProcessInstanceKey() {
        return this.parentProcessInstanceKeyProp.getValue();
    }

    @Override
    public long getParentElementInstanceKey() {
        return this.parentElementInstanceKeyProp.getValue();
    }

    public ProcessInstanceRecord setParentElementInstanceKey(long parentElementInstanceKey) {
        this.parentElementInstanceKeyProp.setValue(parentElementInstanceKey);
        return this;
    }

    @Override
    public BpmnEventType getBpmnEventType() {
        return this.bpmnEventTypeProp.getValue();
    }

    public ProcessInstanceRecord setBpmnEventType(BpmnEventType bpmnEventType) {
        this.bpmnEventTypeProp.setValue(bpmnEventType);
        return this;
    }

    public ProcessInstanceRecord setParentProcessInstanceKey(long parentProcessInstanceKey) {
        this.parentProcessInstanceKeyProp.setValue(parentProcessInstanceKey);
        return this;
    }

    public ProcessInstanceRecord setBpmnElementType(BpmnElementType bpmnType) {
        this.bpmnElementTypeProp.setValue(bpmnType);
        return this;
    }

    public ProcessInstanceRecord setFlowScopeKey(long flowScopeKey) {
        this.flowScopeKeyProp.setValue(flowScopeKey);
        return this;
    }

    public ProcessInstanceRecord setElementId(String elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public ProcessInstanceRecord setElementId(DirectBuffer elementId) {
        return this.setElementId(elementId, 0, elementId.capacity());
    }

    public ProcessInstanceRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProp.setValue(processDefinitionKey);
        return this;
    }

    public ProcessInstanceRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessInstanceRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessInstanceRecord setBpmnProcessId(DirectBuffer directBuffer) {
        this.bpmnProcessIdProp.setValue(directBuffer);
        return this;
    }

    public boolean hasParentProcess() {
        return this.getParentProcessInstanceKey() != -1L;
    }

    public ProcessInstanceRecord setElementId(DirectBuffer elementId, int offset, int length) {
        this.elementIdProp.setValue(elementId, offset, length);
        return this;
    }

    @Override
    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public ProcessInstanceRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

