/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.EscalationRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="EscalationRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableEscalationRecordValue
implements EscalationRecordValue {
    private final String tenantId;
    private final long processInstanceKey;
    private final String escalationCode;
    private final String throwElementId;
    private final String catchElementId;
    private transient int hashCode;

    private ImmutableEscalationRecordValue(String tenantId, long processInstanceKey, String escalationCode, String throwElementId, String catchElementId) {
        this.tenantId = tenantId;
        this.processInstanceKey = processInstanceKey;
        this.escalationCode = escalationCode;
        this.throwElementId = throwElementId;
        this.catchElementId = catchElementId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getEscalationCode() {
        return this.escalationCode;
    }

    @Override
    public String getThrowElementId() {
        return this.throwElementId;
    }

    @Override
    public String getCatchElementId() {
        return this.catchElementId;
    }

    public final ImmutableEscalationRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(value, this.processInstanceKey, this.escalationCode, this.throwElementId, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.tenantId, value, this.escalationCode, this.throwElementId, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withEscalationCode(String value) {
        if (Objects.equals(this.escalationCode, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, value, this.throwElementId, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withThrowElementId(String value) {
        if (Objects.equals(this.throwElementId, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, this.escalationCode, value, this.catchElementId);
    }

    public final ImmutableEscalationRecordValue withCatchElementId(String value) {
        if (Objects.equals(this.catchElementId, value)) {
            return this;
        }
        return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, this.escalationCode, this.throwElementId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEscalationRecordValue && this.equalTo(0, (ImmutableEscalationRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableEscalationRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.escalationCode, another.escalationCode) && Objects.equals(this.throwElementId, another.throwElementId) && Objects.equals(this.catchElementId, another.catchElementId);
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.escalationCode);
        h2 += (h2 << 5) + Objects.hashCode(this.throwElementId);
        h2 += (h2 << 5) + Objects.hashCode(this.catchElementId);
        return h2;
    }

    public String toString() {
        return "EscalationRecordValue{tenantId=" + this.tenantId + ", processInstanceKey=" + this.processInstanceKey + ", escalationCode=" + this.escalationCode + ", throwElementId=" + this.throwElementId + ", catchElementId=" + this.catchElementId + "}";
    }

    public static ImmutableEscalationRecordValue copyOf(EscalationRecordValue instance) {
        if (instance instanceof ImmutableEscalationRecordValue) {
            return (ImmutableEscalationRecordValue)instance;
        }
        return ImmutableEscalationRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="EscalationRecordValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private long processInstanceKey;
        private String escalationCode;
        private String throwElementId;
        private String catchElementId;

        private Builder() {
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(EscalationRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tenantIdValue;
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof EscalationRecordValue) {
                String throwElementIdValue;
                String escalationCodeValue;
                instance = (EscalationRecordValue)object;
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
                this.withProcessInstanceKey(instance.getProcessInstanceKey());
                String catchElementIdValue = instance.getCatchElementId();
                if (catchElementIdValue != null) {
                    this.withCatchElementId(catchElementIdValue);
                }
                if ((escalationCodeValue = instance.getEscalationCode()) != null) {
                    this.withEscalationCode(escalationCodeValue);
                }
                if ((throwElementIdValue = instance.getThrowElementId()) != null) {
                    this.withThrowElementId(throwElementIdValue);
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withEscalationCode(String escalationCode) {
            this.escalationCode = escalationCode;
            return this;
        }

        public final Builder withThrowElementId(String throwElementId) {
            this.throwElementId = throwElementId;
            return this;
        }

        public final Builder withCatchElementId(String catchElementId) {
            this.catchElementId = catchElementId;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.processInstanceKey = 0L;
            this.escalationCode = null;
            this.throwElementId = null;
            this.catchElementId = null;
            return this;
        }

        public ImmutableEscalationRecordValue build() {
            return new ImmutableEscalationRecordValue(this.tenantId, this.processInstanceKey, this.escalationCode, this.throwElementId, this.catchElementId);
        }
    }
}

