/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.ProcessEventRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessEventRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableProcessEventRecordValue
implements ProcessEventRecordValue {
    private final Map<String, Object> variables;
    private final long processInstanceKey;
    private final String tenantId;
    private final long scopeKey;
    private final String targetElementId;
    private final long processDefinitionKey;
    private transient int hashCode;

    private ImmutableProcessEventRecordValue(Map<String, Object> variables, long processInstanceKey, String tenantId, long scopeKey, String targetElementId, long processDefinitionKey) {
        this.variables = variables;
        this.processInstanceKey = processInstanceKey;
        this.tenantId = tenantId;
        this.scopeKey = scopeKey;
        this.targetElementId = targetElementId;
        this.processDefinitionKey = processDefinitionKey;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getScopeKey() {
        return this.scopeKey;
    }

    @Override
    public String getTargetElementId() {
        return this.targetElementId;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public final ImmutableProcessEventRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableProcessEventRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableProcessEventRecordValue(newValue, this.processInstanceKey, this.tenantId, this.scopeKey, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, value, this.tenantId, this.scopeKey, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, value, this.scopeKey, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withScopeKey(long value) {
        if (this.scopeKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.tenantId, value, this.targetElementId, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withTargetElementId(String value) {
        if (Objects.equals(this.targetElementId, value)) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.scopeKey, value, this.processDefinitionKey);
    }

    public final ImmutableProcessEventRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableProcessEventRecordValue(this.variables, this.processInstanceKey, this.tenantId, this.scopeKey, this.targetElementId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessEventRecordValue && this.equalTo(0, (ImmutableProcessEventRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessEventRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.tenantId, another.tenantId) && this.scopeKey == another.scopeKey && Objects.equals(this.targetElementId, another.targetElementId) && this.processDefinitionKey == another.processDefinitionKey;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.variables.hashCode();
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Long.hashCode(this.scopeKey);
        h2 += (h2 << 5) + Objects.hashCode(this.targetElementId);
        h2 += (h2 << 5) + Long.hashCode(this.processDefinitionKey);
        return h2;
    }

    public String toString() {
        return "ProcessEventRecordValue{variables=" + this.variables + ", processInstanceKey=" + this.processInstanceKey + ", tenantId=" + this.tenantId + ", scopeKey=" + this.scopeKey + ", targetElementId=" + this.targetElementId + ", processDefinitionKey=" + this.processDefinitionKey + "}";
    }

    public static ImmutableProcessEventRecordValue copyOf(ProcessEventRecordValue instance) {
        if (instance instanceof ImmutableProcessEventRecordValue) {
            return (ImmutableProcessEventRecordValue)instance;
        }
        return ImmutableProcessEventRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessEventRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private long processInstanceKey;
        private String tenantId;
        private long scopeKey;
        private String targetElementId;
        private long processDefinitionKey;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessEventRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tenantIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessEventRecordValue) {
                String targetElementIdValue;
                instance = (ProcessEventRecordValue)object;
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
                this.withScopeKey(instance.getScopeKey());
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
                if ((targetElementIdValue = instance.getTargetElementId()) != null) {
                    this.withTargetElementId(targetElementIdValue);
                }
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
            }
        }

        public final Builder putVariable(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withScopeKey(long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public final Builder withTargetElementId(String targetElementId) {
            this.targetElementId = targetElementId;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.processInstanceKey = 0L;
            this.tenantId = null;
            this.scopeKey = 0L;
            this.targetElementId = null;
            this.processDefinitionKey = 0L;
            return this;
        }

        public ImmutableProcessEventRecordValue build() {
            return new ImmutableProcessEventRecordValue(ImmutableProcessEventRecordValue.createUnmodifiableMap(false, false, this.variables), this.processInstanceKey, this.tenantId, this.scopeKey, this.targetElementId, this.processDefinitionKey);
        }
    }
}

