/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceBatchRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ProcessInstanceBatchRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableProcessInstanceBatchRecordValue
implements ProcessInstanceBatchRecordValue {
    private final long processInstanceKey;
    private final String tenantId;
    private final long batchElementInstanceKey;
    private final long index;
    private transient int hashCode;

    private ImmutableProcessInstanceBatchRecordValue(long processInstanceKey, String tenantId, long batchElementInstanceKey, long index) {
        this.processInstanceKey = processInstanceKey;
        this.tenantId = tenantId;
        this.batchElementInstanceKey = batchElementInstanceKey;
        this.index = index;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getBatchElementInstanceKey() {
        return this.batchElementInstanceKey;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    public final ImmutableProcessInstanceBatchRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceBatchRecordValue(value, this.tenantId, this.batchElementInstanceKey, this.index);
    }

    public final ImmutableProcessInstanceBatchRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, value, this.batchElementInstanceKey, this.index);
    }

    public final ImmutableProcessInstanceBatchRecordValue withBatchElementInstanceKey(long value) {
        if (this.batchElementInstanceKey == value) {
            return this;
        }
        return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, this.tenantId, value, this.index);
    }

    public final ImmutableProcessInstanceBatchRecordValue withIndex(long value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, this.tenantId, this.batchElementInstanceKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcessInstanceBatchRecordValue && this.equalTo(0, (ImmutableProcessInstanceBatchRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcessInstanceBatchRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.processInstanceKey == another.processInstanceKey && Objects.equals(this.tenantId, another.tenantId) && this.batchElementInstanceKey == another.batchElementInstanceKey && this.index == another.index;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Long.hashCode(this.batchElementInstanceKey);
        h2 += (h2 << 5) + Long.hashCode(this.index);
        return h2;
    }

    public String toString() {
        return "ProcessInstanceBatchRecordValue{processInstanceKey=" + this.processInstanceKey + ", tenantId=" + this.tenantId + ", batchElementInstanceKey=" + this.batchElementInstanceKey + ", index=" + this.index + "}";
    }

    public static ImmutableProcessInstanceBatchRecordValue copyOf(ProcessInstanceBatchRecordValue instance) {
        if (instance instanceof ImmutableProcessInstanceBatchRecordValue) {
            return (ImmutableProcessInstanceBatchRecordValue)instance;
        }
        return ImmutableProcessInstanceBatchRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ProcessInstanceBatchRecordValue", generator="Immutables")
    public static final class Builder {
        private long processInstanceKey;
        private String tenantId;
        private long batchElementInstanceKey;
        private long index;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ProcessInstanceBatchRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tenantIdValue;
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof ProcessInstanceBatchRecordValue) {
                instance = (ProcessInstanceBatchRecordValue)object;
                if ((bits & 2L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withIndex(instance.getIndex());
                this.withBatchElementInstanceKey(instance.getBatchElementInstanceKey());
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 2L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withBatchElementInstanceKey(long batchElementInstanceKey) {
            this.batchElementInstanceKey = batchElementInstanceKey;
            return this;
        }

        public final Builder withIndex(long index) {
            this.index = index;
            return this;
        }

        public Builder clear() {
            this.processInstanceKey = 0L;
            this.tenantId = null;
            this.batchElementInstanceKey = 0L;
            this.index = 0L;
            return this;
        }

        public ImmutableProcessInstanceBatchRecordValue build() {
            return new ImmutableProcessInstanceBatchRecordValue(this.processInstanceKey, this.tenantId, this.batchElementInstanceKey, this.index);
        }
    }
}

