/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.WorkStealingGroup;
import io.camunda.zeebe.util.Loggers;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;

public abstract class ActorThreadGroup {
    protected final String groupName;
    protected final ActorThread[] threads;
    protected final WorkStealingGroup tasks;
    protected final int numOfThreads;
    private final String schedulerName;

    public ActorThreadGroup(String groupName, int numOfThreads, ActorScheduler.ActorSchedulerBuilder builder, String schedulerName) {
        this.groupName = groupName;
        this.numOfThreads = numOfThreads;
        this.schedulerName = schedulerName;
        this.tasks = new WorkStealingGroup(numOfThreads);
        this.threads = new ActorThread[numOfThreads];
        for (int t2 = 0; t2 < numOfThreads; ++t2) {
            ActorThread thread;
            String threadName = String.format("%s-%d", groupName, t2);
            this.threads[t2] = thread = builder.getActorThreadFactory().newThread(threadName, t2, this, this.tasks, builder.getActorClock(), builder.getActorTimerQueue(), builder.isMetricsEnabled(), builder.getIdleStrategySupplier().get());
        }
    }

    public void submit(ActorTask actorTask) {
        ActorThread current = ActorThread.current();
        if (current != null && current.getActorThreadGroup() == this) {
            this.tasks.submit(actorTask, current.getRunnerId());
        } else {
            int threadId = ThreadLocalRandom.current().nextInt(this.numOfThreads);
            this.tasks.submit(actorTask, threadId);
            this.threads[threadId].hintWorkAvailable();
        }
    }

    public void start() {
        for (ActorThread actorThread : this.threads) {
            actorThread.start();
        }
    }

    public String getSchedulerName() {
        return this.schedulerName;
    }

    public CompletableFuture<Void> closeAsync() {
        Loggers.ACTOR_LOGGER.debug("Closing actor thread ground '{}'", (Object)this.groupName);
        CompletableFuture[] terminationFutures = new CompletableFuture[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            ActorThread thread = this.threads[i];
            try {
                terminationFutures[i] = thread.close();
                continue;
            }
            catch (IllegalStateException e) {
                Loggers.ACTOR_LOGGER.error("Closing actor thread ground '{}'. Failed to close thread {}", this.groupName, thread.getRunnerId(), e);
                terminationFutures[i] = CompletableFuture.completedFuture(null);
            }
        }
        return CompletableFuture.allOf(terminationFutures).thenAccept(ok -> Loggers.ACTOR_LOGGER.debug("Closing actor thread ground '{}': closed successfully", (Object)this.groupName));
    }
}

